package ru.yandex.direct.ess.router.rules.mediascopeintegration;

import java.util.List;
import java.util.Objects;

import ru.yandex.direct.ess.config.mediascopeintegration.MediascopePositionChangeConfig;
import ru.yandex.direct.ess.logicobjects.mediascopeintegration.MediascopePositionChangeObject;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.models.rule.StandardRule;
import ru.yandex.direct.ess.router.utils.ColumnsChangeType;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_MEASURERS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;

@EssRule(MediascopePositionChangeConfig.class)
public class MediascopePositionChangeRule extends StandardRule<MediascopePositionChangeObject> {

    public MediascopePositionChangeRule() {
        super(tableChangesHandler -> {

            tableChangesHandler.addTableChange(
                    new TableChange.Builder<MediascopePositionChangeObject>()
                            .setTable(BANNERS_PERFORMANCE)
                            .setOperation(UPDATE)
                            .setColumn(BANNERS_PERFORMANCE.CREATIVE_ID)
                            .setMapper(change ->
                                    new MediascopePositionChangeObject(null, change.getAfter(BANNERS_PERFORMANCE.BID)))
                            .build());

            tableChangesHandler.addTableChange(
                    new TableChange.Builder<MediascopePositionChangeObject>()
                            .setTable(BANNER_MEASURERS)
                            .setOperation(INSERT)
                            .setValuesFilter(MediascopePositionChangeRule::filterBannerMeasurerChange)
                            .setMapper(change ->
                                    new MediascopePositionChangeObject(null, change.getPrimaryKey(BANNER_MEASURERS.BID)))
                            .build());

            tableChangesHandler.addTableChange(
                    new TableChange.Builder<MediascopePositionChangeObject>()
                            .setTable(BANNER_MEASURERS)
                            .setOperation(UPDATE)
                            .setColumn(BANNER_MEASURERS.HAS_INTEGRATION)
                            .setValuesFilter(MediascopePositionChangeRule::filterBannerMeasurerChange)
                            .setMapper(change ->
                                    new MediascopePositionChangeObject(null, change.getPrimaryKey(BANNER_MEASURERS.BID)))
                            .build());

            tableChangesHandler.addTableChange(
                    new TableChange.Builder<MediascopePositionChangeObject>()
                            .setTable(CAMPAIGNS)
                            .setOperation(UPDATE)
                            .setColumns(ColumnsChangeType.ANY,
                                    List.of(CAMPAIGNS.START_TIME, CAMPAIGNS.FINISH_TIME, CAMPAIGNS.NAME))
                            .setMapper(change ->
                                    new MediascopePositionChangeObject(change.getPrimaryKey(CAMPAIGNS.CID), null))
                            .build());
        });
    }

    private static boolean filterBannerMeasurerChange(ProceededChange change) {
        return Objects.equals(1L, change.getAfter(BANNER_MEASURERS.HAS_INTEGRATION));
    }
}
