package ru.yandex.direct.ess.router.rules.metrika.bannerupdate;

import java.util.List;

import org.jooq.TableField;

import ru.yandex.direct.binlog.model.BinlogEvent;
import ru.yandex.direct.ess.common.utils.TablesEnum;
import ru.yandex.direct.ess.config.metrika.bannerupdate.MetrikaBannerUpdateConfig;
import ru.yandex.direct.ess.logicobjects.metrika.bannerupdate.MetrikaBannerUpdateObject;
import ru.yandex.direct.ess.router.models.rule.AbstractRule;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGES;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@EssRule(MetrikaBannerUpdateConfig.class)
public class MetrikaBannerUpdateRule extends AbstractRule<MetrikaBannerUpdateObject> {

    private final TableChangesHandler<MetrikaBannerUpdateObject> tableChangesHandler = new TableChangesHandler<>();
    private static final List<TableField> bannersInterestingFields = List.of(BANNERS.BANNER_ID, BANNERS.TITLE,
            BANNERS.BODY);

    @SuppressWarnings("unused")
    public MetrikaBannerUpdateRule() {
        for (var bannerField : bannersInterestingFields) {
            tableChangesHandler.addTableChange(
                    new TableChange.Builder<MetrikaBannerUpdateObject>()
                            .setTable(BANNERS)
                            .setOperation(UPDATE)
                            .setColumn(bannerField)
                            .setMapper(this::mapBannerToObject)
                            .build());
        }
        tableChangesHandler.addTableChange(
                new TableChange.Builder<MetrikaBannerUpdateObject>()
                        .setTable(BANNER_IMAGES)
                        .setOperation(UPDATE)
                        .setColumn(BANNER_IMAGES.BANNER_ID)
                        .setMapper(this::mapBannerImageToObject)
                        .build());
    }

    @Override
    public List<MetrikaBannerUpdateObject> mapBinlogEvent(BinlogEvent event) {
        return tableChangesHandler.processChanges(event);
    }


    private MetrikaBannerUpdateObject mapBannerToObject(ProceededChange change) {
        return new MetrikaBannerUpdateObject(TablesEnum.BANNERS, change.getPrimaryKey(BANNERS.BID));
    }

    private MetrikaBannerUpdateObject mapBannerImageToObject(ProceededChange change) {
        return new MetrikaBannerUpdateObject(TablesEnum.BANNER_IMAGES, change.getPrimaryKey(BANNER_IMAGES.IMAGE_ID));
    }

}
