package ru.yandex.direct.ess.router.rules.moderation;

import java.util.Map;
import java.util.Set;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.core.entity.moderation.model.TransportStatus;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;

public final class ModerationRulesUtils {
    public static final Map<Operation, Set<String>> objectStatusesByMode = Map.of(
            INSERT, Set.of(TransportStatus.Ready.name(), TransportStatus.Yes.name(),
                    TransportStatus.No.name()),
            UPDATE, Set.of(TransportStatus.Ready.name())
    );
    public static final Set<String> copiedObjectsStatuses = Set.of(TransportStatus.Yes.name(),
            TransportStatus.No.name());

    public static boolean needModeration(String statusModerate, Operation mode) {
        return statusModerate != null && objectStatusesByMode.get(mode).contains(statusModerate);
    }

    public static boolean isCopy(String statusModerate, Operation mode) {
        return ModerationRulesUtils.copiedObjectsStatuses.contains(statusModerate) && mode == INSERT;
    }

    private ModerationRulesUtils() {

    }


}
