package ru.yandex.direct.ess.router.rules.moderation.banner;

import java.util.Set;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.ess.logicobjects.moderation.banner.BannerModerationEventsObject;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRulesUtils;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;


public abstract class BaseBannerModerationRule extends ModerationRule<BannerModerationEventsObject> {

    private final Set<BannersBannerType> bannerTypes; //TODO надо чтобы методы использовали этот объект, а не
    // переменную которая пришла в конструкторе. Ибо она может быть изменена где-то во-вне.

    public BaseBannerModerationRule(BannersBannerType bannerType) {
        this(Set.of(bannerType));
    }


    public BaseBannerModerationRule(Set<BannersBannerType> bannerTypes) {
        super(tableChangesHandler -> {
            tableChangesHandler.addTableChange(
                    new TableChange.Builder<BannerModerationEventsObject>()
                            .setTable(BANNERS)
                            .setOperation(INSERT)
                            .setValuesFilter(pc -> isBannerNeedModeration(pc, bannerTypes, INSERT))
                            .setMapper(pc -> mapChangeToObject(pc, INSERT))
                            .build());
            tableChangesHandler.addTableChange(
                    new TableChange.Builder<BannerModerationEventsObject>()
                            .setTable(BANNERS)
                            .setOperation(UPDATE)
                            .setColumn(BANNERS.STATUS_MODERATE)
                            .setValuesFilter(pc -> isBannerNeedModeration(pc, bannerTypes, UPDATE))
                            .setMapper(pc -> mapChangeToObject(pc, UPDATE))
                            .build());
        });

        this.bannerTypes = Set.copyOf(bannerTypes);
    }

    public Set<BannersBannerType> getBannerType() {
        return bannerTypes;
    }

    private static boolean isBannerNeedModeration(ProceededChange change, Set<BannersBannerType> bannerTypes,
                                                  Operation mode) {
        var status = change.getAfter(BANNERS.STATUS_MODERATE);

        return ModerationRulesUtils.needModeration((String) status, mode)
                && change.getAfter(BANNERS.BANNER_TYPE) != null
                && bannerTypes.contains(BannersBannerType.valueOf(change.getAfter(BANNERS.BANNER_TYPE)));
    }

    private static BannerModerationEventsObject mapChangeToObject(ProceededChange change, Operation mode) {
        return new BannerModerationEventsObject(getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                change.getAfter(BANNERS.CID),
                change.getAfter(BANNERS.PID),
                change.getPrimaryKey(BANNERS.BID),
                BannersBannerType.valueOf(change.getAfter(BANNERS.BANNER_TYPE)),
                ModerationRulesUtils.isCopy(change.getAfter(BANNERS.STATUS_MODERATE), mode),
                false);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}
