package ru.yandex.direct.ess.router.rules.moderation.bannerstorage;

import java.math.BigInteger;

import ru.yandex.direct.dbschema.ppc.enums.PerfCreativesCreativeType;
import ru.yandex.direct.dbschema.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.direct.ess.config.moderation.banner.BannerstorageCreativeModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.bannerstorage.BannerstorageCreativeModerationEventsObject;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule;
import ru.yandex.direct.ess.router.utils.ColumnsChangeType;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static java.util.Arrays.asList;
import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.PERF_CREATIVES;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;

@EssRule(BannerstorageCreativeModerationConfig.class)
public class BannerstorageCreativeModerationRule extends ModerationRule<BannerstorageCreativeModerationEventsObject> {

    public BannerstorageCreativeModerationRule() {
        super(tableChangesHandler -> {
            tableChangesHandler.addTableChange(
                    new TableChange.Builder<BannerstorageCreativeModerationEventsObject>()
                            .setTable(PERF_CREATIVES)
                            .setOperation(INSERT)
                            .setValuesFilter(BannerstorageCreativeModerationRule::isModerationNeeded)
                            .setMapper(BannerstorageCreativeModerationRule::mapChangeToObject)
                            .build()
            );

            tableChangesHandler.addTableChange(
                    new TableChange.Builder<BannerstorageCreativeModerationEventsObject>()
                            .setTable(PERF_CREATIVES)
                            .setOperation(UPDATE)
                            .setColumns(
                                    ColumnsChangeType.ANY,
                                    asList(PERF_CREATIVES.STATUS_MODERATE, PERF_CREATIVES.IS_BANNERSTORAGE_PREDEPLOYED)
                            )
                            .setValuesFilter(BannerstorageCreativeModerationRule::isModerationNeeded)
                            .setMapper(BannerstorageCreativeModerationRule::mapChangeToObject)
                            .build()
            );
        });
    }

    private static boolean isModerationNeeded(ProceededChange proceededChange) {
        // creative_type всегда присутствует в after (колока добавлена в whitelist binlogbroker'a)
        Object creativeType = proceededChange.getAfter(PERF_CREATIVES.CREATIVE_TYPE);
        if (!PerfCreativesCreativeType.performance.getLiteral().equals(creativeType)
                && !PerfCreativesCreativeType.bannerstorage.getLiteral().equals(creativeType)) {
            return false;
        }
        // statusModerate может не быть (если был update is_bannerstorage_predeployed),
        // но если есть, то оно должно быть Ready
        Object statusModerate = proceededChange.getAfter(PERF_CREATIVES.STATUS_MODERATE);
        // is_bannerstorage_predeployed может не быть (если был update statusModerate),
        // но если есть, то оно должно быть равно 1
        Object isPredeployed = proceededChange.getAfter(PERF_CREATIVES.IS_BANNERSTORAGE_PREDEPLOYED);
        return PerfCreativesStatusmoderate.Ready.getLiteral().equals(statusModerate)
                || (statusModerate == null && Long.valueOf(1).equals(isPredeployed));
    }

    private static BannerstorageCreativeModerationEventsObject mapChangeToObject(ProceededChange change) {
        return new BannerstorageCreativeModerationEventsObject(getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                ((BigInteger) change.getPrimaryKey(PERF_CREATIVES.CREATIVE_ID)).longValue(), false);
    }
}
