package ru.yandex.direct.ess.router.rules.moderation.callout;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.config.moderation.callout.CalloutModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.callout.CalloutModerationEventsObject;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRulesUtils;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.ADDITIONS_ITEM_CALLOUTS;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;

@EssRule(CalloutModerationConfig.class)
public class CalloutModerationRule extends ModerationRule<CalloutModerationEventsObject> {

    public CalloutModerationRule() {
        super(tableChangesHandler -> {
                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<CalloutModerationEventsObject>()
                                    .setTable(ADDITIONS_ITEM_CALLOUTS)
                                    .setOperation(INSERT)
                                    .setValuesFilter(change -> isCalloutNeedModeration(change, INSERT))
                                    .setMapper(e -> mapChangeToObject(e, INSERT))
                                    .build()
                    );

                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<CalloutModerationEventsObject>()
                                    .setTable(ADDITIONS_ITEM_CALLOUTS)
                                    .setOperation(UPDATE)
                                    .setColumn(ADDITIONS_ITEM_CALLOUTS.STATUS_MODERATE)
                                    .setValuesFilter(change -> isCalloutNeedModeration(change, UPDATE))
                                    .setMapper(e -> mapChangeToObject(e, UPDATE))
                                    .build()
                    );
                }
        );
    }

    private static boolean isCalloutNeedModeration(ProceededChange change, Operation mode) {
        return ModerationRulesUtils.needModeration(change.getAfter(ADDITIONS_ITEM_CALLOUTS.STATUS_MODERATE), mode);
    }

    private static CalloutModerationEventsObject mapChangeToObject(ProceededChange change, Operation mode) {
        return new CalloutModerationEventsObject(getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                ModerationRulesUtils.isCopy(change.getAfter(ADDITIONS_ITEM_CALLOUTS.STATUS_MODERATE), mode),
                change.getPrimaryKey(ADDITIONS_ITEM_CALLOUTS.ADDITIONS_ITEM_ID)
        );
    }
}
