package ru.yandex.direct.ess.router.rules.moderation.contentpromotion;

import ru.yandex.direct.ess.config.moderation.contentpromotion.ContentPromotionAccessibilityConfig;
import ru.yandex.direct.ess.logicobjects.moderation.contentpromotion.ContentPromotionAccessibilityLogicObject;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.CONTENT_PROMOTION;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;

@EssRule(ContentPromotionAccessibilityConfig.class)
public class ContentPromotionAccessibilityModerationRule extends ModerationRule<ContentPromotionAccessibilityLogicObject> {

    public ContentPromotionAccessibilityModerationRule() {
        super(tableChangesHandler -> tableChangesHandler.addTableChange(
                new TableChange.Builder<ContentPromotionAccessibilityLogicObject>()
                        .setTable(CONTENT_PROMOTION)
                        .setOperation(UPDATE)
                        .setColumn(CONTENT_PROMOTION.IS_INACCESSIBLE)
                        .setMapper(ContentPromotionAccessibilityModerationRule::mapChangeToLogicObject)
                        .build()));
    }

    private static ContentPromotionAccessibilityLogicObject mapChangeToLogicObject(ProceededChange proceededChange) {
        return new ContentPromotionAccessibilityLogicObject(
                getProceededChangeEssTag(proceededChange),
                getProceededChangeTimestamp(proceededChange),
                proceededChange.getPrimaryKey(CONTENT_PROMOTION.ID),
                proceededChange.getAfter(CONTENT_PROMOTION.IS_INACCESSIBLE), false);
    }
}
