package ru.yandex.direct.ess.router.rules.moderation.displayhrefs;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.config.moderation.banner.DisplayHrefsModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.displayhrefs.DisplayHrefsModerationEventsObject;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRulesUtils;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_DISPLAY_HREFS;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;

@EssRule(DisplayHrefsModerationConfig.class)
public class DisplayHrefsModerationRule extends ModerationRule<DisplayHrefsModerationEventsObject> {

    public DisplayHrefsModerationRule() {
        super(tableChangesHandler -> {
                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<DisplayHrefsModerationEventsObject>()
                                    .setTable(BANNER_DISPLAY_HREFS)
                                    .setOperation(Operation.INSERT)
                                    .setValuesFilter(e -> isDisplayHrefNeedModeration(e, Operation.INSERT))
                                    .setMapper(e -> mapChangeToObject(e, Operation.INSERT))
                                    .build()
                    );

                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<DisplayHrefsModerationEventsObject>()
                                    .setTable(BANNER_DISPLAY_HREFS)
                                    .setOperation(Operation.UPDATE)
                                    .setColumn(BANNER_DISPLAY_HREFS.STATUS_MODERATE)
                                    .setValuesFilter(e -> isDisplayHrefNeedModeration(e, Operation.UPDATE))
                                    .setMapper(e -> mapChangeToObject(e, Operation.UPDATE))
                                    .build()
                    );

                }
        );
    }

    private static boolean isDisplayHrefNeedModeration(ProceededChange change, Operation mode) {
        return ModerationRulesUtils.needModeration(change.getAfter(BANNER_DISPLAY_HREFS.STATUS_MODERATE), mode);
    }

    private static DisplayHrefsModerationEventsObject mapChangeToObject(ProceededChange change, Operation mode) {
        return new DisplayHrefsModerationEventsObject(getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                change.getPrimaryKey(BANNER_DISPLAY_HREFS.BID),
                ModerationRulesUtils.isCopy(change.getAfter(BANNER_DISPLAY_HREFS.STATUS_MODERATE), mode));
    }

}
