package ru.yandex.direct.ess.router.rules.moderation.image;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.config.moderation.banner.ImageModerationConfig;
import ru.yandex.direct.ess.logicobjects.image.ImageModerationEventsObject;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRulesUtils;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGES;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;

@EssRule(ImageModerationConfig.class)
public class ImageModerationRule extends ModerationRule<ImageModerationEventsObject> {

    public ImageModerationRule() {
        super(tableChangesHandler -> {
                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<ImageModerationEventsObject>()
                                    .setTable(BANNER_IMAGES)
                                    .setOperation(INSERT)
                                    .setValuesFilter(e -> isBannerImageNeedModeration(e, INSERT))
                                    .setMapper(e -> mapChangeToObject(e, INSERT))
                                    .build()
                    );

                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<ImageModerationEventsObject>()
                                    .setTable(BANNER_IMAGES)
                                    .setOperation(UPDATE)
                                    .setColumn(BANNER_IMAGES.STATUS_MODERATE)
                                    .setValuesFilter(e -> isBannerImageNeedModeration(e, UPDATE))
                                    .setMapper(e -> mapChangeToObject(e, UPDATE))
                                    .build()
                    );

                }
        );
    }

    private static boolean isBannerImageNeedModeration(ProceededChange change, Operation mode) {
        return ModerationRulesUtils.needModeration(change.getAfter(BANNER_IMAGES.STATUS_MODERATE), mode);
    }

    private static ImageModerationEventsObject mapChangeToObject(ProceededChange change, Operation mode) {
        return new ImageModerationEventsObject(getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                change.getPrimaryKey(BANNER_IMAGES.IMAGE_ID),
                ModerationRulesUtils.isCopy(change.getAfter(BANNER_IMAGES.STATUS_MODERATE), mode)
        );
    }

}
