package ru.yandex.direct.ess.router.rules.moderation.mobilecontenticon;

import java.math.BigInteger;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.config.moderation.mobilecontenticon.MobileContentIconModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.mobilecontenticon.MobileContentIconModerationEventsObject;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRulesUtils;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.MOBILE_CONTENT;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;

@EssRule(MobileContentIconModerationConfig.class)
public class MobileContentIconModerationRule extends ModerationRule<MobileContentIconModerationEventsObject> {
    public MobileContentIconModerationRule() {
        super(tableChangesHandler -> {
                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<MobileContentIconModerationEventsObject>()
                                    .setTable(MOBILE_CONTENT)
                                    .setOperation(INSERT)
                                    .setValuesFilter(change -> isIconNeedModeration(change, INSERT))
                                    .setMapper(e -> mapChangeToObject(e, INSERT))
                                    .build()
                    );

                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<MobileContentIconModerationEventsObject>()
                                    .setTable(MOBILE_CONTENT)
                                    .setOperation(UPDATE)
                                    .setColumn(MOBILE_CONTENT.STATUS_ICON_MODERATE)
                                    .setValuesFilter(change -> isIconNeedModeration(change, UPDATE))
                                    .setMapper(e -> mapChangeToObject(e, UPDATE))
                                    .build()
                    );
                }
        );
    }

    private static boolean isIconNeedModeration(ProceededChange change, Operation mode) {
        return ModerationRulesUtils.needModeration(change.getAfter(MOBILE_CONTENT.STATUS_ICON_MODERATE), mode);
    }

    private static MobileContentIconModerationEventsObject mapChangeToObject(ProceededChange change, Operation mode) {
        return new MobileContentIconModerationEventsObject(getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                ModerationRulesUtils.isCopy(change.getAfter(MOBILE_CONTENT.STATUS_ICON_MODERATE), mode),
                ((BigInteger) change.getPrimaryKey(MOBILE_CONTENT.MOBILE_CONTENT_ID)).longValue()
        );
    }
}
