package ru.yandex.direct.ess.router.rules.moderation.promoaction

import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.binlog.model.Operation.INSERT
import ru.yandex.direct.binlog.model.Operation.UPDATE
import ru.yandex.direct.dbschema.ppc.Tables.PROMOACTIONS
import ru.yandex.direct.ess.config.moderation.promoaction.PromoactionModerationConfig
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule
import ru.yandex.direct.ess.logicobjects.moderation.promoaction.PromoactionModerationEventsObject
import ru.yandex.direct.ess.router.models.rule.EssRule
import ru.yandex.direct.ess.router.rules.moderation.ModerationRulesUtils
import ru.yandex.direct.ess.router.utils.ProceededChange
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.ProceededChangeUtil

@EssRule(PromoactionModerationConfig::class)
class PromoactionModerationRule : ModerationRule<PromoactionModerationEventsObject>(
    { tableChangesHandler ->
        tableChangesHandler.addTableChange(
            TableChange.Builder<PromoactionModerationEventsObject>()
                .setTable(PROMOACTIONS)
                .setOperation(INSERT)
                .setValuesFilter { e -> isPromoactionNeedModeration(e, INSERT) }
                .setMapper { e -> mapChangeToObject(e, INSERT) }
                .build()
        );

        tableChangesHandler.addTableChange(
            TableChange.Builder<PromoactionModerationEventsObject>()
                .setTable(PROMOACTIONS)
                .setOperation(UPDATE)
                .setColumn(PROMOACTIONS.STATUS_MODERATE)
                .setValuesFilter { e -> isPromoactionNeedModeration(e, UPDATE) }
                .setMapper { e -> mapChangeToObject(e, UPDATE) }
                .build()
        );

    }
) {
    companion object {
        private fun isPromoactionNeedModeration(change: ProceededChange, mode: Operation): Boolean {
            return ModerationRulesUtils.needModeration(change.getAfter(PROMOACTIONS.STATUS_MODERATE), mode)
        }

        private fun mapChangeToObject(change: ProceededChange, mode: Operation): PromoactionModerationEventsObject {
            return PromoactionModerationEventsObject(
                ProceededChangeUtil.getProceededChangeEssTag(change),
                ProceededChangeUtil.getProceededChangeTimestamp(change),
                ModerationRulesUtils.isCopy(change.getAfter(PROMOACTIONS.STATUS_MODERATE), mode),
                change.getLongPrimaryKey(PROMOACTIONS.ID),
            )
        }
    }
}
