package ru.yandex.direct.ess.router.rules.moderation.sitelinks;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.config.moderation.banner.SitelinksModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.sitelinks.SitelinksModerationEventsObject;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRulesUtils;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;

@EssRule(SitelinksModerationConfig.class)
public class SitelinksModerationRule extends ModerationRule<SitelinksModerationEventsObject> {

    public SitelinksModerationRule() {
        super(tableChangesHandler -> {
                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<SitelinksModerationEventsObject>()
                                    .setTable(BANNERS)
                                    .setOperation(Operation.INSERT)
                                    .setValuesFilter(e -> isSitelinksNeedModeration(e, Operation.INSERT))
                                    .setMapper(e -> mapChangeToObject(e, Operation.INSERT))
                                    .build()
                    );

                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<SitelinksModerationEventsObject>()
                                    .setTable(BANNERS)
                                    .setOperation(Operation.UPDATE)
                                    .setColumn(BANNERS.STATUS_SITELINKS_MODERATE)
                                    .setValuesFilter(e -> isSitelinksNeedModeration(e, Operation.UPDATE))
                                    .setMapper(e -> mapChangeToObject(e, Operation.UPDATE))
                                    .build()
                    );

                }
        );
    }

    private static boolean isSitelinksNeedModeration(ProceededChange change, Operation mode) {
        return ModerationRulesUtils.needModeration(change.getAfter(BANNERS.STATUS_SITELINKS_MODERATE), mode);
    }

    private static SitelinksModerationEventsObject mapChangeToObject(ProceededChange change, Operation mode) {
        return new SitelinksModerationEventsObject(getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                change.getPrimaryKey(BANNERS.BID),
                ModerationRulesUtils.isCopy(change.getAfter(BANNERS.STATUS_SITELINKS_MODERATE), mode));
    }

}
