package ru.yandex.direct.ess.router.rules.moderation.special;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusarch;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsArchived;
import ru.yandex.direct.ess.config.moderation.special.ModerationArchivingConfig;
import ru.yandex.direct.ess.logicobjects.moderation.special.ModerationArchivingEvent;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;

@EssRule(ModerationArchivingConfig.class)
public class ModerationArchivingRule extends ModerationRule<ModerationArchivingEvent> {

    public ModerationArchivingRule() {
        super(handler -> {
            handler.addTableChange(
                    new TableChange.Builder<ModerationArchivingEvent>()
                            .setTable(BANNERS)
                            .setColumn(BANNERS.STATUS_ARCH)
                            .setOperation(Operation.UPDATE)
                            .setValuesFilter(ModerationArchivingRule::bannerStatusArchFilter)
                            .setMapper(ModerationArchivingRule::mapBannerChange)
                            .build());

            handler.addTableChange(
                    new TableChange.Builder<ModerationArchivingEvent>()
                            .setTable(CAMPAIGNS)
                            .setColumn(CAMPAIGNS.ARCHIVED)
                            .setOperation(Operation.UPDATE)
                            .setValuesFilter(ModerationArchivingRule::campaignArchivedFilter)
                            .setMapper(ModerationArchivingRule::mapCampaignChange)
                            .build());

            handler.addTableChange(
                    new TableChange.Builder<ModerationArchivingEvent>()
                            .setTable(BANNERS)
                            .setColumn(BANNERS.STATUS_ARCH)
                            .setOperation(Operation.INSERT)
                            .setValuesFilter(ModerationArchivingRule::bannerStatusArchFilter)
                            .setMapper(ModerationArchivingRule::mapBannerChange)
                            .build());

            handler.addTableChange(
                    new TableChange.Builder<ModerationArchivingEvent>()
                            .setTable(CAMPAIGNS)
                            .setColumn(CAMPAIGNS.ARCHIVED)
                            .setOperation(Operation.INSERT)
                            .setValuesFilter(ModerationArchivingRule::campaignArchivedFilter)
                            .setMapper(ModerationArchivingRule::mapCampaignChange)
                            .build());
        });
    }

    private static boolean bannerStatusArchFilter(ProceededChange change) {
        return BannersStatusarch.Yes.name().equals(
                change.getAfter(BANNERS.STATUS_ARCH));
    }

    private static boolean campaignArchivedFilter(ProceededChange change) {
        return CampaignsArchived.Yes.name().equals(
                change.getAfter(CAMPAIGNS.ARCHIVED));
    }

    private static ModerationArchivingEvent mapBannerChange(ProceededChange change) {
        return ModerationArchivingEvent.bannerArchivingEvent(
                getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                change.getAfter(BANNERS.CID),
                change.getAfter(BANNERS.PID),
                change.getPrimaryKey(BANNERS.BID),
                BannersBannerType.valueOf(change.getAfter(BANNERS.BANNER_TYPE)));
    }

    private static ModerationArchivingEvent mapCampaignChange(ProceededChange change) {
        return ModerationArchivingEvent.campaignArchivingEvent(
                getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                change.getPrimaryKey(CAMPAIGNS.CID));
    }
}
