package ru.yandex.direct.ess.router.rules.moderation.special;

import org.jooq.Field;
import org.jooq.Table;

import ru.yandex.direct.ess.common.circuits.moderation.ModerationDeletionObjectType;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_BUTTONS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_DISPLAY_HREFS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGES;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_LOGOS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;

public class ModerationDeletionTypeUtil {

    private ModerationDeletionTypeUtil() {
        // only static methods
    }

    public static ModerationDeletionObjectType getDeletedObjectType(Table<?> table, Field<?> field) {
        return field != null ?
                getTypeForDeletedFieldValue(table, field) :
                getTypeForDeletedRow(table);
    }

    private static ModerationDeletionObjectType getTypeForDeletedFieldValue(Table<?> table, Field<?> field) {
        if (table.equals(BANNERS)) {
            if (field.equals(BANNERS.VCARD_ID)) {
                return ModerationDeletionObjectType.ASSET_VCARD;
            } else if (field.equals(BANNERS.SITELINKS_SET_ID)) {
                return ModerationDeletionObjectType.ASSET_SITELINK_SET;
            }
        }
        return null;
    }

    private static ModerationDeletionObjectType getTypeForDeletedRow(Table<?> table) {
        if (table.equals(BANNERS)) {
            return ModerationDeletionObjectType.BANNER;
        }

        if (table.equals(PHRASES)) {
            return ModerationDeletionObjectType.ADGROUP;
        }

        if (table.equals(BANNERS_PERFORMANCE)) {
            return ModerationDeletionObjectType.ASSET_CREATIVE;
        }

        if (table.equals(BANNER_IMAGES)) {
            return ModerationDeletionObjectType.ASSET_IMAGE;
        }

        if (table.equals(BANNER_TURBOLANDINGS)) {
            return ModerationDeletionObjectType.ASSET_TURBOLANDING;
        }

        if (table.equals(BANNER_DISPLAY_HREFS)) {
            return ModerationDeletionObjectType.ASSET_DISPLAY_HREF;
        }

        if (table.equals(BANNER_LOGOS)) {
            return ModerationDeletionObjectType.ASSET_LOGO;
        }

        if (table.equals(BANNER_BUTTONS)) {
            return ModerationDeletionObjectType.ASSET_BUTTON;
        }
        return null;
    }
}
