package ru.yandex.direct.ess.router.rules.moderation.special;

import java.util.function.Function;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.config.moderation.special.ModerationFlagsConfig;
import ru.yandex.direct.ess.logicobjects.moderation.special.ModerationFlagsEvent;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_USER_FLAGS_UPDATES;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;

@EssRule(ModerationFlagsConfig.class)
public class ModerationFlagsRule extends ModerationRule<ModerationFlagsEvent> {

    @Autowired
    public ModerationFlagsRule() {
        super(handler -> {
            handler.addTableChange(new TableChange.Builder<ModerationFlagsEvent>()
                    .setTable(BANNER_USER_FLAGS_UPDATES)
                    .setOperation(Operation.INSERT)
                    .setMapper(mapper())
                    .build());

            handler.addTableChange(new TableChange.Builder<ModerationFlagsEvent>()
                    .setTable(BANNER_USER_FLAGS_UPDATES)
                    .setOperation(Operation.UPDATE)
                    .setMapper(mapper())
                    .build());
        });
    }

    private static Function<ProceededChange, ModerationFlagsEvent> mapper() {
        return change -> new ModerationFlagsEvent(
                getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                change.getAfter(BANNER_USER_FLAGS_UPDATES.CID),
                change.getAfter(BANNER_USER_FLAGS_UPDATES.PID),
                change.getPrimaryKey(BANNER_USER_FLAGS_UPDATES.BID),
                null);
    }
}
