package ru.yandex.direct.ess.router.rules.moderation.turbolandings;

import ru.yandex.direct.binlog.model.Operation;
import ru.yandex.direct.ess.config.moderation.banner.TurbolandingsModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.turbolandings.TurbolandingsModerationEventsObject;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRule;
import ru.yandex.direct.ess.router.rules.moderation.ModerationRulesUtils;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeEssTag;
import static ru.yandex.direct.ess.router.utils.ProceededChangeUtil.getProceededChangeTimestamp;

@EssRule(TurbolandingsModerationConfig.class)
public class TurbolandingsModerationRule extends ModerationRule<TurbolandingsModerationEventsObject> {

    public TurbolandingsModerationRule() {
        super(tableChangesHandler -> {
                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<TurbolandingsModerationEventsObject>()
                                    .setTable(BANNER_TURBOLANDINGS)
                                    .setOperation(INSERT)
                                    .setValuesFilter(e -> isTurbolandingNeedModeration(e, INSERT))
                                    .setMapper(e -> mapChangeToObject(e, INSERT))
                                    .build()
                    );

                    tableChangesHandler.addTableChange(
                            new TableChange.Builder<TurbolandingsModerationEventsObject>()
                                    .setTable(BANNER_TURBOLANDINGS)
                                    .setOperation(Operation.UPDATE)
                                    .setColumn(BANNER_TURBOLANDINGS.STATUS_MODERATE)
                                    .setValuesFilter(e -> isTurbolandingNeedModeration(e, UPDATE))
                                    .setMapper(e -> mapChangeToObject(e, UPDATE))
                                    .build()
                    );

                }
        );
    }

    private static boolean isTurbolandingNeedModeration(ProceededChange change, Operation mode) {
        return ModerationRulesUtils.needModeration(change.getAfter(BANNER_TURBOLANDINGS.STATUS_MODERATE), mode);
    }

    private static TurbolandingsModerationEventsObject mapChangeToObject(ProceededChange change, Operation mode) {
        return new TurbolandingsModerationEventsObject(getProceededChangeEssTag(change),
                getProceededChangeTimestamp(change),
                change.getPrimaryKey(BANNER_TURBOLANDINGS.BID),
                ModerationRulesUtils.isCopy(change.getAfter(BANNER_TURBOLANDINGS.STATUS_MODERATE), mode));
    }

}
