package ru.yandex.direct.ess.router.rules.promocodescheckcampaignchanges;

import java.util.List;

import org.jooq.Field;

import ru.yandex.direct.binlog.model.BinlogEvent;
import ru.yandex.direct.ess.config.promocodescheckcampaignchanges.PromocodesCheckCampaignChangesConfig;
import ru.yandex.direct.ess.logicobjects.promocodescheckcampaignchanges.IdTypeEnum;
import ru.yandex.direct.ess.logicobjects.promocodescheckcampaignchanges.PromocodesCheckCampaignChangesObject;
import ru.yandex.direct.ess.router.models.rule.AbstractRule;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.DELETE;
import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.tables.AdgroupsDynamic.ADGROUPS_DYNAMIC;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@EssRule(PromocodesCheckCampaignChangesConfig.class)
public class PromocodesCheckCampaignChangesRule extends AbstractRule<PromocodesCheckCampaignChangesObject> {

    private static final TableChangesHandler<PromocodesCheckCampaignChangesObject> tableChangesHandler =
            new TableChangesHandler<>();

    static {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<PromocodesCheckCampaignChangesObject>()
                        .setTable(BANNERS)
                        .setOperation(INSERT)
                        .setMapper(PromocodesCheckCampaignChangesRule::mapBannerChangeToObject)
                        .build());
        tableChangesHandler.addTableChange(
                new TableChange.Builder<PromocodesCheckCampaignChangesObject>()
                        .setTable(BANNERS)
                        .setOperation(UPDATE)
                        .setColumn(BANNERS.DOMAIN)
                        .setMapper(PromocodesCheckCampaignChangesRule::mapBannerChangeToObject)
                        .build());
        tableChangesHandler.addTableChange(
                new TableChange.Builder<PromocodesCheckCampaignChangesObject>()
                        .setTable(ADGROUPS_DYNAMIC)
                        .setOperation(INSERT)
                        .setMapper(PromocodesCheckCampaignChangesRule::mapAdgroupsDynamicChangeToObject)
                        .build());
        tableChangesHandler.addTableChange(
                new TableChange.Builder<PromocodesCheckCampaignChangesObject>()
                        .setTable(ADGROUPS_DYNAMIC)
                        .setOperation(UPDATE)
                        .setColumn(ADGROUPS_DYNAMIC.MAIN_DOMAIN_ID)
                        .setMapper(PromocodesCheckCampaignChangesRule::mapAdgroupsDynamicChangeToObject)
                        .build());
    }

    @Override
    public List<PromocodesCheckCampaignChangesObject> mapBinlogEvent(BinlogEvent event) {
        return tableChangesHandler.processChanges(event);
    }

    private static PromocodesCheckCampaignChangesObject mapBannerChangeToObject(ProceededChange change) {

        return new PromocodesCheckCampaignChangesObject(extractId(change, BANNERS.CID), IdTypeEnum.CID);
    }

    private static PromocodesCheckCampaignChangesObject mapAdgroupsDynamicChangeToObject(ProceededChange change) {
        return new PromocodesCheckCampaignChangesObject(change.getPrimaryKey(ADGROUPS_DYNAMIC.PID), IdTypeEnum.PID);
    }

    private static Long extractId(ProceededChange change, Field<Long> field) {
        if (change.getOperation() != DELETE) {
            return change.getAfter(field);
        } else {
            return change.getBefore(field);
        }
    }
}
