package ru.yandex.direct.ess.router.rules.recomtracer;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.binlog.model.BinlogEvent;
import ru.yandex.direct.ess.config.recomtracer.RecomTracerConfig;
import ru.yandex.direct.ess.logicobjects.recomtracer.RecomTracerLogicObject;
import ru.yandex.direct.ess.router.models.rule.AbstractRule;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

@EssRule(RecomTracerConfig.class)
public class RecomTracerRule extends AbstractRule<RecomTracerLogicObject> {


    private final TableChangesHandler<RecomTracerLogicObject> tableChangesHandler = new TableChangesHandler<>();

    @Autowired
    public RecomTracerRule(List<RecomTracerChangeHandler> recomTracerChangeHandlers) {
        recomTracerChangeHandlers.forEach(recomTracerChange ->
                recomTracerChange.initInterestingChanges(tableChangesHandler));
    }

    @Override
    public List<RecomTracerLogicObject> mapBinlogEvent(BinlogEvent binlogEvent) {
        return tableChangesHandler.processChanges(binlogEvent);
    }
}
