package ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.banners;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.recommendation.RecommendationType;
import ru.yandex.direct.ess.logicobjects.recomtracer.RecomTracerLogicObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_ADDITIONS;
import static ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.ChangeHandlerHelper.createSimpleBannerChangeLogicObject;

/**
 * Рекомендация "Добавьте уточнения".
 * <p>
 * Следим за insert в таблице banners_additions.
 * По bid из этой таблицы загружаем информацию о ClientID, cid, pid, и скрываем рекомендации.
 */
@Component
public class AddAdditionsItemCalloutsChangeHandler extends BaseBannersTracerChangeHandler {
    @Override
    public RecommendationType supportedType() {
        return RecommendationType.addAdditionItemCallouts;
    }

    @Override
    public void initInterestingChanges(TableChangesHandler<RecomTracerLogicObject> tableChangesHandler) {
        super.initInterestingChanges(tableChangesHandler);
        tableChangesHandler.addTableChange(
                new TableChange.Builder<RecomTracerLogicObject>()
                        .setTable(BANNERS_ADDITIONS)
                        .setOperation(INSERT)
                        .setMapper(this::mapBannersAdditions)
                        .build()
        );
    }

    private RecomTracerLogicObject mapBannersAdditions(ProceededChange change) {
        Long bid = change.getAfter(BANNERS_ADDITIONS.BID);
        return createSimpleBannerChangeLogicObject(supportedType().getId(), bid);
    }
}
