package ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.banners;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.recommendation.RecommendationType;
import ru.yandex.direct.ess.logicobjects.recomtracer.RecomTracerLogicObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_DISPLAY_HREFS;
import static ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.ChangeHandlerHelper.createSimpleBannerChangeLogicObject;

/**
 * Рекомендация "Добавьте отображаемые ссылки".
 * <p>
 * Следим за insert в таблице banner_display_hrefs.
 * По bid из этой таблицы загружаем информацию о ClientID, cid, pid, и скрываем рекомендации.
 */
@Component
public class AddBannerDisplayHrefsChangeHandler extends BaseBannersTracerChangeHandler {
    @Override
    public RecommendationType supportedType() {
        return RecommendationType.addBannerDisplayHrefs;
    }

    @Override
    public void initInterestingChanges(TableChangesHandler<RecomTracerLogicObject> tableChangesHandler) {
        super.initInterestingChanges(tableChangesHandler);
        tableChangesHandler.addTableChange(
                new TableChange.Builder<RecomTracerLogicObject>()
                        .setTable(BANNER_DISPLAY_HREFS)
                        .setOperation(INSERT)
                        .setMapper(this::mapBannersDisplayHrefs)
                        .build());
    }

    private RecomTracerLogicObject mapBannersDisplayHrefs(ProceededChange change) {
        Long bid = change.getPrimaryKey(BANNER_DISPLAY_HREFS.BID);
        return createSimpleBannerChangeLogicObject(supportedType().getId(), bid);
    }
}
