package ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.banners;

import java.util.Objects;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.recommendation.RecommendationType;
import ru.yandex.direct.ess.logicobjects.recomtracer.RecomTracerLogicObject;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.INSERT;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGES;
import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.ChangeHandlerHelper.createSimpleBannerChangeLogicObject;

/**
 * Рекомендация "Добавьте изображения"
 */
@Component
public class AddImageToBannerChangeHandler extends BaseBannersTracerChangeHandler {
    @Override
    public RecommendationType supportedType() {
        return RecommendationType.addImageToBanner;
    }

    @Override
    public void initInterestingChanges(TableChangesHandler<RecomTracerLogicObject> tableChangesHandler) {
        super.initInterestingChanges(tableChangesHandler);
        tableChangesHandler.addTableChange(
                new TableChange.Builder<RecomTracerLogicObject>()
                        .setTable(CAMPAIGNS)
                        .setOperation(UPDATE)
                        .setColumn(CAMPAIGNS.PLATFORM)
                        .setValuesFilter(this::isPlatformBecameSearch)
                        .setMapper(this::mapCampaigns)
                        .build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<RecomTracerLogicObject>()
                        .setTable(BANNER_IMAGES)
                        .setOperation(INSERT)
                        .setMapper(this::mapBannersImages)
                        .build());
    }

    private boolean isPlatformBecameSearch(ProceededChange change) {
        if (change.beforeContains(CAMPAIGNS.PLATFORM) && change.afterContains(CAMPAIGNS.PLATFORM)) {
            String platformBefore = change.getBefore(CAMPAIGNS.PLATFORM);
            String platformAfter = change.getAfter(CAMPAIGNS.PLATFORM);
            return !Objects.equals(platformBefore, platformAfter) && "search".equals(platformAfter);
        }
        return false;
    }

    private RecomTracerLogicObject mapBannersImages(ProceededChange change) {
        Long bid = change.getAfter(BANNER_IMAGES.BID);
        return createSimpleBannerChangeLogicObject(supportedType().getId(), bid);
    }


}
