package ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.banners;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.recommendation.RecommendationType;
import ru.yandex.direct.ess.logicobjects.recomtracer.RecomTracerLogicObject;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.core.entity.recommendation.RecommendationType.addSiteLinks;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

/**
 * Рекомендация "Добавьте сайтлинки".
 * <p>
 * Отслеживаем изменение banners.sitelinks_set_id и скрываем рекомендации, если поле было изменено.
 * Плюс как и везде, следим за архивностью кампаний и баннеров.
 */
@Component
public class AddSitelinksChangeHandler extends BaseBannersTracerChangeHandler {
    @Override
    public RecommendationType supportedType() {
        return addSiteLinks;
    }

    @Override
    public void initInterestingChanges(TableChangesHandler<RecomTracerLogicObject> tableChangesHandler) {
        super.initInterestingChanges(tableChangesHandler);
        // Меняется sitelinks_set_id -- можем скрыть относящиеся к этому рекомендации
        tableChangesHandler.addTableChange(
                new TableChange.Builder<RecomTracerLogicObject>()
                        .setTable(BANNERS)
                        .setOperation(UPDATE)
                        .setColumn(BANNERS.SITELINKS_SET_ID)
                        .setMapper(this::mapBanners)
                        .build()
        );
    }
}
