package ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.banners;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.recommendation.RecommendationType;
import ru.yandex.direct.ess.logicobjects.recomtracer.RecomTracerLogicObject;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Component
public class AddTitleExtensionChangeHandler extends BaseBannersTracerChangeHandler {
    @Override
    public RecommendationType supportedType() {
        return RecommendationType.addTitleExtension;
    }

    @Override
    public void initInterestingChanges(TableChangesHandler<RecomTracerLogicObject> tableChangesHandler) {
        super.initInterestingChanges(tableChangesHandler);
        // title_extension - колонка с типом text, а бинлоги у нас включены в режиме NOBLOB, поэтому значение
        // before не придёт
        tableChangesHandler.addTableChange(
                new TableChange.Builder<RecomTracerLogicObject>()
                        .setTable(BANNERS)
                        .setOperation(UPDATE)
                        .setColumn(BANNERS.TITLE_EXTENSION)
                        .setMapper(this::mapBanners)
                        .build()
        );
    }
}
