package ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.banners;

import ru.yandex.direct.ess.logicobjects.recomtracer.RecomTracerLogicObject;
import ru.yandex.direct.ess.router.rules.recomtracer.RecomTracerChangeHandler;
import ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.ChangeHandlerHelper;
import ru.yandex.direct.ess.router.utils.ProceededChange;
import ru.yandex.direct.ess.router.utils.TableChange;
import ru.yandex.direct.ess.router.utils.TableChangesHandler;

import static ru.yandex.direct.binlog.model.Operation.DELETE;
import static ru.yandex.direct.binlog.model.Operation.UPDATE;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.ChangeHandlerHelper.createBannerChangeCanAffectedGroupLogicObject;
import static ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.ChangeHandlerHelper.createBannerChangeLogicObject;
import static ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.ChangeHandlerHelper.createCampaignChangeLogicObject;
import static ru.yandex.direct.ess.router.rules.recomtracer.changehandlers.ChangeHandlerHelper.createPhrasesChangeLogicObject;

public abstract class BaseBannersTracerChangeHandler implements RecomTracerChangeHandler {
    @Override
    public void initInterestingChanges(TableChangesHandler<RecomTracerLogicObject> tableChangesHandler) {
        tableChangesHandler.addTableChange(
                new TableChange.Builder<RecomTracerLogicObject>()
                        .setTable(CAMPAIGNS)
                        .setOperation(UPDATE)
                        .setColumn(CAMPAIGNS.ARCHIVED)
                        .setValuesFilter(ChangeHandlerHelper::isCampaignBecameArchived)
                        .setMapper(this::mapCampaigns)
                        .build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<RecomTracerLogicObject>()
                        .setTable(PHRASES)
                        .setOperation(DELETE)
                        .setMapper(this::mapPhrases)
                        .build());

        /*
         * Если баннер удалился, в logicProcessor'е делается дополнительная проверка, что не все оставшиеся баннеры
         * на группе являются архивными
         * Такое поведение актуально только для рекомендаций на группе, но по сколько для всех удаленных баннеров
         * будет делаться запрос в mysql для проверки (из-за SwitchOnAutotargetingChangeHandler), то не будем делать
         * еще один запрос для таких событый, только без проверки архивности группы
         */
        tableChangesHandler.addTableChange(
                new TableChange.Builder<RecomTracerLogicObject>()
                        .setTable(BANNERS)
                        .setOperation(DELETE)
                        .setMapper(this::mapBannersDeleteOrBecameArchive)
                        .build());

        /*
         * Аналогично удаленным баннерам
         */
        tableChangesHandler.addTableChange(
                new TableChange.Builder<RecomTracerLogicObject>()
                        .setTable(BANNERS)
                        .setOperation(UPDATE)
                        .setColumn(BANNERS.STATUS_ARCH)
                        .setValuesFilter(ChangeHandlerHelper::isBannersStatusArchChanged)
                        .setMapper(this::mapBannersDeleteOrBecameArchive)
                        .build());

        tableChangesHandler.addTableChange(
                new TableChange.Builder<RecomTracerLogicObject>()
                        .setTable(BANNERS)
                        .setOperation(UPDATE)
                        .setColumn(BANNERS.STATUS_MODERATE)
                        .setValuesFilter(ChangeHandlerHelper::isBannerStatusModerateChanged)
                        .setMapper(this::mapBanners)
                        .build());
    }

    RecomTracerLogicObject mapCampaigns(ProceededChange change) {
        return createCampaignChangeLogicObject(supportedType().getId(), change);
    }

    RecomTracerLogicObject mapBanners(ProceededChange change) {
        return createBannerChangeLogicObject(supportedType().getId(), change);
    }

    private RecomTracerLogicObject mapBannersDeleteOrBecameArchive(ProceededChange change) {
        return createBannerChangeCanAffectedGroupLogicObject(supportedType().getId(), change);
    }

    private RecomTracerLogicObject mapPhrases(ProceededChange change) {
        return createPhrasesChangeLogicObject(supportedType().getId(), change);
    }
}
