package ru.yandex.direct.ess.router.rules.userblock

import ru.yandex.direct.binlog.model.BinlogEvent
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.dbschema.ppc.Tables.USERS
import ru.yandex.direct.dbschema.ppc.enums.UsersStatusblocked
import ru.yandex.direct.ess.config.userblock.UserBlockConfig
import ru.yandex.direct.ess.logicobjects.userblock.UserBlockObject
import ru.yandex.direct.ess.router.models.rule.AbstractRule
import ru.yandex.direct.ess.router.models.rule.EssRule
import ru.yandex.direct.ess.router.utils.TableChange
import ru.yandex.direct.ess.router.utils.TableChangesHandler

@EssRule(UserBlockConfig::class)
class UserBlockRule : AbstractRule<UserBlockObject>() {

    private val tableChangesHandler = TableChangesHandler<UserBlockObject>()

    init {
        tableChangesHandler.addTableChange(
            TableChange.Builder<UserBlockObject>()
                .setTable(USERS)
                .setColumn(USERS.STATUS_BLOCKED)
                .setOperation(Operation.UPDATE)
                .setValuesFilter { it.getAfter<String, UsersStatusblocked>(USERS.STATUS_BLOCKED) == "Yes" }
                .setMapper { UserBlockObject(it.getPrimaryKey(USERS.UID)) }
                .build()
        )

    }

    override fun mapBinlogEvent(binlogEvent: BinlogEvent): List<UserBlockObject> {
        return tableChangesHandler.processChanges(binlogEvent)
    }

}
