package ru.yandex.direct.ess.router.utils;

import java.util.function.Function;

import ru.yandex.direct.ess.router.models.TEssEvent;
import ru.yandex.grut.objects.proto.client.Schema.EObjectType;

import static com.google.common.base.Preconditions.checkArgument;

public class GrutTableChange<T> {

    private final EObjectType objectType;
    private final Function<TEssEvent, T> watchlogMapper;

    private GrutTableChange(EObjectType objectType, Function<TEssEvent, T> watchlogMapper) {
        this.objectType = objectType;
        this.watchlogMapper = watchlogMapper;
    }

    public EObjectType getObjectType() {
        return objectType;
    }

    public Function<TEssEvent, T> getWatchlogMapper() {
        return watchlogMapper;
    }

    public static class Builder<T> {
        private EObjectType objectType;
        private Function<TEssEvent, T> watchlogMapper;

        public Builder<T> setObjectType(EObjectType objectType) {
            this.objectType = objectType;
            return this;
        }

        public Builder<T> setWatchlogMapper(Function<TEssEvent, T> watchlogMapper) {
            this.watchlogMapper = watchlogMapper;
            return this;
        }

        public GrutTableChange<T> build() {
            checkArgument(objectType != null, "Null objectType!");
            checkArgument(watchlogMapper != null, "Null watchlogMapper!");
            return new GrutTableChange<>(objectType, watchlogMapper);
        }
    }
}
