package ru.yandex.direct.ess.router.utils;

import java.time.ZoneOffset;

import static org.apache.commons.lang3.StringUtils.isEmpty;

public class ProceededChangeUtil {

    private ProceededChangeUtil() {
    }

    public static String getProceededChangeEssTag(ProceededChange change) {
        return isEmpty(change.getEssTag()) ? null : change.getEssTag();
    }

    public static Long getProceededChangeTimestamp(ProceededChange change) {
        return change.getBinlogTimestamp() == null ?
                null :
                change.getBinlogTimestamp().toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}
