package ru.yandex.direct.ess.router.utils

import org.jooq.Named
import org.jooq.impl.TableImpl
import ru.yandex.direct.binlog.model.Operation
import ru.yandex.direct.ess.common.models.BaseLogicObject
import java.util.function.Predicate

// Для совместимости с java-кодом (там не поддерживаются значения по-умолчанию для аргументов)
fun <BLO : BaseLogicObject> addRulesToHandler(
    tableChangesHandler: TableChangesHandler<BLO>,
    table: TableImpl<*>,
    mapper: (ProceededChange) -> BLO,
    updateColumns: List<Named> = listOf(),
) {
    addRulesToHandler(tableChangesHandler, table, mapper, updateColumns, null, ALL_OPERATIONS)
}

// Для совместимости с java-кодом (там не поддерживаются значения по-умолчанию для аргументов)
fun <BLO : BaseLogicObject> addRulesToHandler(
    tableChangesHandler: TableChangesHandler<BLO>,
    table: TableImpl<*>,
    mapper: (ProceededChange) -> BLO,
    updateColumns: List<Named> = listOf(),
    valuesFilter: Predicate<ProceededChange>? = null,
) {
    addRulesToHandler(tableChangesHandler, table, mapper, updateColumns, valuesFilter, ALL_OPERATIONS)
}

// Для совместимости с java-кодом (там не поддерживаются значения по-умолчанию для аргументов)
fun <BLO : BaseLogicObject> addRulesToHandler(
    tableChangesHandler: TableChangesHandler<BLO>,
    table: TableImpl<*>,
    mapper: (ProceededChange) -> BLO,
    updateColumns: List<Named> = listOf(),
    operations: Set<Operation> = ALL_OPERATIONS,
) {
    addRulesToHandler(tableChangesHandler, table, mapper, updateColumns, null, operations)
}

val ALL_OPERATIONS = Operation.values().toSet()

fun <BLO : BaseLogicObject> addRulesToHandler(
    tableChangesHandler: TableChangesHandler<BLO>,
    table: TableImpl<*>,
    mapper: (ProceededChange) -> BLO,
    updateColumns: List<Named> = listOf(),
    valuesFilter: Predicate<ProceededChange>? = null,
    operations: Set<Operation> = ALL_OPERATIONS,
) {
    if (operations.contains(Operation.INSERT)) {
        val insertTableChange = TableChange.Builder<BLO>()
            .setTable(table)
            .setOperation(Operation.INSERT)
            .setMapper(mapper)
        if (valuesFilter != null) {
            insertTableChange.setValuesFilter(valuesFilter)
        }
        tableChangesHandler.addTableChange(insertTableChange.build())
    }

    if (operations.contains(Operation.UPDATE)) {
        val updateTableChange = TableChange.Builder<BLO>()
            .setTable(table)
            .setOperation(Operation.UPDATE)
            .setMapper(mapper)
        if (updateColumns.isNotEmpty()) {
            updateTableChange.setColumns(ColumnsChangeType.ANY, updateColumns)
        }
        if (valuesFilter != null) {
            updateTableChange.setValuesFilter(valuesFilter)
        }
        tableChangesHandler.addTableChange(updateTableChange.build())
    }

    if (operations.contains(Operation.DELETE)) {
        val deleteTableChange = TableChange.Builder<BLO>()
            .setTable(table)
            .setOperation(Operation.DELETE)
            .setMapper(mapper)
        if (valuesFilter != null) {
            deleteTableChange.setValuesFilter(valuesFilter)
        }
        tableChangesHandler.addTableChange(deleteTableChange.build())
    }
}
