package ru.yandex.direct.reports.issues;

import java.util.Comparator;
import java.util.Optional;

import one.util.streamex.StreamEx;

import ru.yandex.direct.tools.goals.Goal;
import ru.yandex.direct.tools.goals.GoalComment;

import static java.util.Collections.emptyList;

public class GoalGroup extends Group {
    public static final String GOAL_HREF = "https://goals.yandex-team.ru/filter?goal=%s";

    private final Goal goal;
    private final String id;

    public GoalGroup(Goal goal) {
        this.goal = goal;
        id = goal.getId().toString();
    }

    @Override
    public String link() {
        return String.format(GOAL_HREF, goal.getId());
    }

    @Override
    public String text() {
        return goal.getTitle();
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public Double order() {
        return goal.getImportance().doubleValue();
    }

    @Override
    public Comment lastComment() {
        GoalComment comment =
                StreamEx.of(Optional.ofNullable(goal.getComments()).orElse(emptyList()))
                        .max(Comparator.comparing(GoalComment::getId))
                        .orElse(null);
        if (comment == null) {
            return null;
        }
        return new Comment(comment.getText(), comment.getOwnerLogin(), comment.getUpdated());
    }
}
