package ru.yandex.direct.reports.issues;

import java.util.Objects;

import javax.annotation.Nullable;

public abstract class Group {
    public abstract String link();

    public abstract String text();

    public abstract String id();

    public abstract Double order();

    @Nullable
    public abstract Comment lastComment();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Group that = (Group) o;
        return Objects.equals(id(), that.id());
    }

    @Override
    public int hashCode() {
        return Objects.hash(id());
    }
}
