package ru.yandex.direct.reports.issues;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import one.util.streamex.StreamEx;

import ru.yandex.bolts.collection.Option; //IGNORE-BAD-STYLE DIRECT-119910
import ru.yandex.startrek.client.model.Issue;
import ru.yandex.startrek.client.model.UserRef;

public class IssueGroup extends Group {
    public static final String ST_HREF = "https://st.yandex-team.ru/";
    private static final String WEIGHT = "weight";
    private static final String PENDING_REPLY_FROM = "pendingReplyFrom";

    private final Issue issue;
    private final String id;

    public IssueGroup(Issue issue) {
        this.issue = issue;
        id = issue.getId();
    }

    @Override
    public String link() {
        return ST_HREF + issue.getKey();
    }

    @Override
    public String text() {
        return issue.getSummary();
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public Double order() {
        var w = issue.getO(WEIGHT);
        double val = 60.;
        if (w.isPresent()) {
            val = ((Option.Some<Double>) w.get()).get();
        }
        return val;
    }

    @Override
    public Comment lastComment() {
        return null;
    }

    public Set<String> pendingReplyFrom() {
        var pending = issue.getO(PENDING_REPLY_FROM);
        if (pending.isPresent()) {
            return StreamEx.of((List<UserRef>) pending.get())
                    .map(UserRef::getLogin)
                    .toSet();
        } else {
            return Collections.emptySet();
        }
    }
}
