package ru.yandex.direct.reports.issues;

import ru.yandex.direct.tools.goals.Goal;
import ru.yandex.startrek.client.model.Issue;

public class IssueInfo {
    private Group group1;
    private Group group2;

    private Goal umbrella;
    private Goal goal;
    private Issue root;

    private final Issue self;
    private final IssueGroup selfGroup;

    public IssueInfo(Issue self) {
        this.self = self;
        selfGroup = new IssueGroup(self);
    }

    public String getAssigneeLogin() {
        return self.getAssignee().get().getLogin();
    }

    public String getStatus() {
        return self.getStatus().getKey();
    }

    public String getType() {
        return self.getType().getKey();
    }

    public String getKey() {
        return self.getKey();
    }

    public Group getGroup1() {
        return group1;
    }

    public IssueInfo withGroup1(Group group1) {
        this.group1 = group1;
        return this;
    }

    public Group getGroup2() {
        return group2;
    }

    public IssueInfo withGroup2(Group group2) {
        this.group2 = group2;
        return this;
    }

    public IssueGroup self() {
        return selfGroup;
    }

    public Goal getUmbrella() {
        return umbrella;
    }

    public IssueInfo withUmbrella(Goal umbrella) {
        this.umbrella = umbrella;
        return this;
    }

    public Issue getRoot() {
        return root;
    }

    public IssueInfo withRoot(Issue root) {
        this.root = root;
        return this;
    }

    public Goal getGoal() {
        return goal;
    }

    public IssueInfo withGoal(Goal goal) {
        this.goal = goal;
        return this;
    }
}
