package ru.yandex.direct.tools;

import java.nio.file.Path;
import java.time.Duration;

import org.asynchttpclient.AsyncHttpClient;

import ru.yandex.direct.asynchttp.FetcherSettings;
import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.config.DirectConfigFactory;
import ru.yandex.direct.staff.client.StaffClient;
import ru.yandex.direct.staff.client.model.StaffConfiguration;
import ru.yandex.direct.tools.goals.GoalsClient;
import ru.yandex.direct.tools.wiki.WikiClient;
import ru.yandex.direct.utils.io.FileUtils;
import ru.yandex.startrek.client.Session;

public class IntranetTools {
    private static String intranetOAuthToken;

    static {
        String tokenPath = DirectConfigFactory.getConfig()
                .getBranch("maintenance-helpers")
                .getString("intranet_token_file");
        Path path = FileUtils.expandHome(tokenPath);
        intranetOAuthToken = FileUtils.readToken(path);
    }

    private IntranetTools() {
    }

    public static StaffClient createStaffClient(AsyncHttpClient httpClient) {
        String staffApiUrl = "https://staff-api.yandex-team.ru";
        String gapsApiUrl = "https://staff.yandex-team.ru/gap-api/api";
        StaffConfiguration staffConfiguration = new StaffConfiguration(staffApiUrl, gapsApiUrl, intranetOAuthToken);
        FetcherSettings fetcherSettings = new FetcherSettings()
                .withParallel(1)
                .withConnectTimeout(Duration.ofSeconds(5))
                .withGlobalTimeout(Duration.ofSeconds(60))
                .withRequestTimeout(Duration.ofSeconds(30))
                .withRequestRetries(3);
        ParallelFetcherFactory fetcherFactory = new ParallelFetcherFactory(httpClient,
                fetcherSettings);
        return new StaffClient(staffConfiguration, fetcherFactory, null, true);
    }

    public static WikiClient createWikiClient(AsyncHttpClient httpClient) {
        String wikiApiUrl = "https://wiki-api.yandex-team.ru/_api/frontend";
        FetcherSettings fetcherSettings = new FetcherSettings()
                .withParallel(1)
                .withConnectTimeout(Duration.ofSeconds(5))
                .withGlobalTimeout(Duration.ofSeconds(60))
                .withRequestTimeout(Duration.ofSeconds(30))
                .withRequestRetries(3);
        ParallelFetcherFactory fetcherFactory = new ParallelFetcherFactory(httpClient,
                fetcherSettings);
        return new WikiClient(wikiApiUrl, intranetOAuthToken, fetcherFactory);
    }

    public static GoalsClient createGoalsClient(Session stClient) {
        return new GoalsClient(stClient);
    }
}
