package ru.yandex.direct.tools.wiki;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.core.Smart;
import ru.yandex.direct.http.smart.http.Body;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.Path;

import static ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors;

public class WikiClient {
    private WikiApi api;

    interface WikiApi {
        /**
         * Создать страницу
         */
        @POST("/{path}")
        Call<Void> createOrUpdatePage(@Json @Body WikiPageRequest pageBody, @Path("path") String pagePath);
    }

    public WikiClient(String url, String token, ParallelFetcherFactory parallelFetcherFactory) {
        api = Smart.builder()
                .withParallelFetcherFactory(parallelFetcherFactory)
                .withProfileName("wiki_api")
                .withBaseUrl(url)
                .addHeaderConfigurator(headers -> headers.add("Content-type", "application/json"))
                .addHeaderConfigurator(headers -> headers.add("Authorization", "OAuth " + token))
                .build()
                .create(WikiApi.class);
    }

    public void createOrUpdatePage(String title, String body, String path) {
        WikiPageRequest request = new WikiPageRequest().withBody(body).withTitle(title);
        Result<Void> result = api.createOrUpdatePage(request, path).execute();
        checkResultForErrors(result, WikiClientException::new);
    }
}
