package ru.yandex.direct.mirrors.preprocessor

/**
 * представление домена из mirrors.res
 */
data class MirrorHost(
    val host: String,
    val isHttps: Boolean
) {
    override fun toString() =
        if (isHttps) HTTPS_PROTOCOL + host
        else host

    companion object {
        private const val PROTOCOL_SEPARATOR = "://"
        private const val HTTPS_PROTOCOL = "https://"

        /**
         * распарсить домен, как он указывается в mirrors.res - может быть порт и схема http или https
         */
        fun parse(mirrorsDomain: String): MirrorHost {
            var domain = mirrorsDomain.toLowerCase()

            val isHttps = domain.startsWith(HTTPS_PROTOCOL)

            // убирает протокол
            domain = domain.substringAfter(PROTOCOL_SEPARATOR)
            // убирает порт
            domain = domain.substringBefore(':')

            return MirrorHost(domain, isHttps)
        }
    }

}
