#!/usr/bin/env bash

# Скрипт для выполнения umnount/mount для всех таблиц в директории
# Пример запуска:
#
# sudo YT_PROXY=hahn YT_TOKEN_PATH=/etc/direct-tokens/yt_robot-direct-yt ./unmount-mount.sh '//home/direct/test/santama/mysql-sync/v.15/ppc:1/straight'

if [ "$#" -ne 1 ]; then
    >&2 echo "Usage: YT_PROXY=<cluster> YT_TOKEN_PATH=<token_path> $0 <base_directory>"
    exit 2
fi

BASE_DIR="$1"
TABLES=$(yt list "${BASE_DIR}")

while true; do
    read -p "Unmount all dynamic tables from ${BASE_DIR} ? (y,n) " yn
    case $yn in
        [Yy]* )
            for table in ${TABLES[@]}; do
                echo "Unmounting ${BASE_DIR}/${table}.."
                yt unmount-table ${BASE_DIR}/${table}
            done
        break;;

        [Nn]* ) break;;
        * ) echo "Please answer yes or no.";;
    esac
done

while true; do
    read -p "Mount all dynamic tables ? (y,n) " yn
    case $yn in
        [Yy]* )
            for table in ${TABLES[@]}; do
                echo "Mounting ${BASE_DIR}/${table}.."
                yt mount-table ${BASE_DIR}/${table}
            done
        break;;

        [Nn]* ) break;;
        * ) echo "Please answer yes or no.";;
    esac
done

echo "Finished OK"
