package ru.yandex.direct.mysql;

import org.slf4j.Logger;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import ru.yandex.direct.jcommander.ParserWithHelp;
import ru.yandex.direct.logging.LoggingInitializer;
import ru.yandex.direct.logging.LoggingInitializerParams;
import ru.yandex.direct.mysql.ytsync.configuration.YtSyncSpringConfiguration;
import ru.yandex.direct.mysql.ytsync.export.components.TablesExporter;

/**
 * Точка входа для запуска начального импорта данных
 */
public class RunInitialImport {
    private static final Logger logger = LoggingInitializer.getLogger(RunInitialImport.class);

    public static void main(String[] args) {
        LoggingInitializerParams loggingParams = new LoggingInitializerParams();
        ParserWithHelp.parse(RunInitialImport.class.getCanonicalName(), args, loggingParams);
        LoggingInitializer.initialize(loggingParams, System.getProperty("YT_SYNC_LOG_NAME"));

        try (AnnotationConfigApplicationContext context =
                     new AnnotationConfigApplicationContext(YtSyncSpringConfiguration.class)) {
            TablesExporter task = context.getBean(TablesExporter.class);
            task.runInitialImport();
        } catch (Throwable e) {
            logger.error("Unexpected exception in main", e);
            throw e;
        }
    }
}
