package ru.yandex.direct.mysql.ytsync.configuration

import org.springframework.beans.factory.annotation.Value
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import org.springframework.context.annotation.Import
import ru.yandex.direct.config.DirectConfig
import ru.yandex.direct.mysql.ytsync.configuration.YtSyncSpringConfiguration.YT_SYNC_CLUSTER
import ru.yandex.direct.mysql.ytsync.configuration.YtSyncSpringConfiguration.YT_SYNC_DB_NAMES

@Configuration
@Import(YtSyncSpringConfiguration::class)
class B2YtSpringConfiguration {
    @Bean(YT_SYNC_DB_NAMES)
    fun dbShards(directConfig: DirectConfig): List<String> {
        return directConfig.getStringList("yt-sync.default.dbnames")
    }

    @Bean(YT_SYNC_CLUSTER)
    fun ytSyncCluster(@Value("\${yt-sync.cluster}") cluster: String): String {
        return cluster
    }
}
