package ru.yandex.direct.mysql.ytsync.implementations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.db.config.DbConfig;
import ru.yandex.direct.mysql.ytsync.common.util.MySqlConnectionSettings;
import ru.yandex.direct.mysql.ytsync.common.util.YtSyncCommonUtil;

public class ConnectionSettings implements MySqlConnectionSettings {
    private final String dbName;
    private final int shard;
    private final List<String> hosts;
    private final int port;
    private final String user;
    private final String pass;

    ConnectionSettings(DbConfig dbConfig) {
        this.dbName = dbConfig.getDbName();
        this.shard = YtSyncCommonUtil.extractShard(dbConfig.getDbName());
        this.hosts = Collections.unmodifiableList(new ArrayList<>(dbConfig.getHosts()));
        this.port = dbConfig.getPort();
        this.user = dbConfig.getUser();
        this.pass = dbConfig.getPass();
    }

    @Override
    public String getDbName() {
        return dbName;
    }

    @Override
    public int getShard() {
        return shard;
    }

    @Override
    public List<String> getHosts() {
        return hosts;
    }

    @Override
    public int getPort() {
        return port;
    }

    @Override
    public String getUser() {
        return user;
    }

    @Override
    public String getPass() {
        return pass;
    }

    @Override
    public boolean isEqualTo(MySqlConnectionSettings other) {
        return equals(other);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ConnectionSettings that = (ConnectionSettings) o;
        return shard == that.shard &&
                port == that.port &&
                dbName.equals(that.dbName) &&
                hosts.equals(that.hosts) &&
                user.equals(that.user) &&
                pass.equals(that.pass);
    }

    @Override
    public int hashCode() {
        return Objects.hash(dbName, shard, hosts, port, user, pass);
    }

    @Override
    public String toString() {
        return "ConnectionSettings{" +
                "dbName='" + dbName + '\'' +
                ", shard=" + shard +
                ", hosts=" + hosts +
                ", port=" + port +
                ", user='" + user + '\'' +
                ", pass='" + StringUtils.repeat("*", pass.length()) + '\'' +
                '}';
    }
}
