package ru.yandex.direct.mysql.ytsync.task.builders;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import ru.yandex.direct.mysql.ytsync.export.util.valueprocessing.ResultSetValueExtractor;
import ru.yandex.direct.mysql.ytsync.synchronizator.tableprocessors.MySqlColumnValueExtractor;
import ru.yandex.misc.lang.number.UnsignedLong;

public class FieldExtractorsPair<T> {
    static final FieldExtractorsPair<Long> LONG_EXTR =
            new FieldExtractorsPair<>(MySqlColumnValueExtractor.longExtractor(),
                    ResultSetValueExtractor.longExtractor());
    static final FieldExtractorsPair<String> STRING_EXTR =
            new FieldExtractorsPair<>(MySqlColumnValueExtractor.stringExtractor(),
                    ResultSetValueExtractor.stringExtractor());
    static final FieldExtractorsPair<UnsignedLong> ULONG_EXTR =
            new FieldExtractorsPair<>(MySqlColumnValueExtractor.unsignedLongExtractor(),
                    ResultSetValueExtractor.unsignedLongExtractor());
    static final FieldExtractorsPair<BigDecimal> DOUBLE_EXTR =
            new FieldExtractorsPair<>(MySqlColumnValueExtractor.doubleExtractor(),
                    ResultSetValueExtractor.doubleExtractor());
    static final FieldExtractorsPair<LocalDate> LOCALDATE_EXTR =
            new FieldExtractorsPair<>(MySqlColumnValueExtractor.localDateExtractor(),
                    ResultSetValueExtractor.localDateExtractor());
    static final FieldExtractorsPair<LocalDateTime> LOCALDATETIME_EXTR =
            new FieldExtractorsPair<>(MySqlColumnValueExtractor.localDateTimeExtractor(),
                    ResultSetValueExtractor.localDateTimeExtractor());

    private final MySqlColumnValueExtractor<T> sync;
    private final ResultSetValueExtractor<T> export;

    private FieldExtractorsPair(
            MySqlColumnValueExtractor<T> sync,
            ResultSetValueExtractor<T> export) {
        this.sync = sync;
        this.export = export;
    }

    public MySqlColumnValueExtractor<T> getSync() {
        return sync;
    }

    public ResultSetValueExtractor<T> getExport() {
        return export;
    }
}
