package ru.yandex.direct.mysql.ytsync.task.builders;

import java.util.Arrays;
import java.util.function.Function;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.misc.lang.number.UnsignedLong;

@ParametersAreNonnullByDefault
public class JooqTaskBuilderUtil {
    private JooqTaskBuilderUtil() {
    }

    public static YTreeNode emptyOrStringNode(@Nullable String value) {
        if (value == null) {
            return YTree.builder().entity().build();
        } else {
            return YTree.stringNode(value);
        }
    }

    public static YTreeNode emptyOrLongNode(@Nullable Long value) {
        if (value == null) {
            return YTree.builder().entity().build();
        } else {
            return YTree.integerNode(value);
        }
    }

    public static YTreeNode emptyOrUnsignedLongNode(@Nullable UnsignedLong value) {
        if (value == null) {
            return YTree.builder().entity().build();
        } else {
            return YTree.builder().value(value).build();
        }
    }

    public static YTreeNode emptyOrBooleanNode(@Nullable Boolean value) {
        if (value == null) {
            return YTree.builder().entity().build();
        } else {
            return YTree.builder().value(value).build();
        }
    }

    public static Function<String, Boolean> hasInSet(String value) {
        return s -> Arrays.stream(s.split(","))
                .anyMatch(p -> p.trim().equals(value));
    }
}
