package ru.yandex.direct.mysql.ytsync.task.builders;

import java.util.function.Function;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.mysql.ytsync.export.util.valueprocessing.ExportFieldProcessor;
import ru.yandex.direct.mysql.ytsync.export.util.valueprocessing.ResultSetValueExtractor;
import ru.yandex.direct.mysql.ytsync.synchronizator.tableprocessors.MySqlColumnValueExtractor;
import ru.yandex.direct.mysql.ytsync.synchronizator.tableprocessors.SyncFlatRowFieldProcessor;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

@ParametersAreNonnullByDefault
public class SyncTaskItem<T, D> {
    private final String srcTable;
    private final String srcTableAlias;
    private final String srcFieldName;
    private final String srcFieldAlias;
    private final String dstFieldName;
    private final ColumnValueType dstType;
    private final String dstExpression;

    private final Integer indexPriority;
    private final boolean isKey;

    private final FieldExtractorsPair<T> fieldExtractors;
    private final Function<T, D> transformer;
    private final Function<String, YTreeNode> defaultValueProvider;

    SyncTaskItem(@Nullable String srcTable, String srcFieldName,
                 String dstFieldName, ColumnValueType dstType,
                 @Nullable Function<String, YTreeNode> defaultValueProvider,
                 @Nullable Function<T, D> transformer, @Nullable String dstExpression,
                 @Nullable Integer indexPriority, boolean isKey,
                 @Nullable FieldExtractorsPair<T> fieldExtractors) {
        this(srcTable, srcTable, srcFieldName, srcFieldName, dstFieldName, dstType, defaultValueProvider, transformer,
                dstExpression, indexPriority, isKey, fieldExtractors);
    }

    SyncTaskItem(@Nullable String srcTable, @Nullable String srcTableAlias,
                 String srcFieldName, String srcFieldAlias,
                 String dstFieldName, ColumnValueType dstType,
                 @Nullable Function<String, YTreeNode> defaultValueProvider,
                 @Nullable Function<T, D> transformer, @Nullable String dstExpression,
                 @Nullable Integer indexPriority, boolean isKey,
                 @Nullable FieldExtractorsPair<T> fieldExtractors) {
        this.srcTable = srcTable;
        this.srcTableAlias = srcTableAlias;
        this.srcFieldName = srcFieldName;
        this.srcFieldAlias = srcFieldAlias;
        this.dstFieldName = dstFieldName;
        this.dstType = dstType;
        this.defaultValueProvider = defaultValueProvider;
        this.transformer = transformer;
        this.dstExpression = dstExpression;
        this.indexPriority = indexPriority != null ? indexPriority : Integer.MIN_VALUE;
        this.isKey = isKey;
        this.fieldExtractors = fieldExtractors;
    }

    public String getSrcTable() {
        return srcTable;
    }

    public String getSrcTableAlias() {
        return srcTableAlias;
    }

    public String getSrcFieldName() {
        return srcFieldName;
    }

    public String getSrcFieldAlias() {
        return srcFieldAlias;
    }

    public String getDstFieldName() {
        return dstFieldName;
    }

    public ColumnValueType getDstType() {
        return dstType;
    }

    public String getDstExpression() {
        return dstExpression;
    }

    public boolean isKey() {
        return isKey;
    }

    public Integer getIndexPriority() {
        return indexPriority;
    }

    public SyncFlatRowFieldProcessor<T> createSyncFieldProcessor() {
        return new SyncFlatRowFieldProcessor<>(dstFieldName, defaultValueProvider, getSyncExtractor(), transformer);
    }

    private MySqlColumnValueExtractor<T> getSyncExtractor() {
        if (fieldExtractors == null) {
            return null;
        }
        return fieldExtractors.getSync();
    }

    public ExportFieldProcessor<T> createExportFieldProcessor() {
        return new ExportFieldProcessor<>(dstFieldName, defaultValueProvider, getExportExtractor(), transformer);
    }

    private ResultSetValueExtractor<T> getExportExtractor() {
        if (fieldExtractors == null) {
            return null;
        }
        return fieldExtractors.getExport();
    }
}
