package ru.yandex.direct.mysql.ytsync.task.config;

import com.typesafe.config.Config;

import ru.yandex.direct.config.DirectConfig;

abstract class RootPathConfig {
    private static final String PPC_DBNAME = "ppc";
    static final String PPCDICT_DBNAME = "ppcdict";

    private final Config pathSettings;

    RootPathConfig(DirectConfig directConfig) {
        Config primarySettings = directConfig.getBranch("yt-sync").getConfig();
        this.pathSettings = primarySettings.getConfig("path");
    }

    public String getBaseSchemaName() {
        return PPC_DBNAME;
    }

    public String getPpcDictSchemaName() {
        return PPCDICT_DBNAME;
    }

    /**
     * Путь к корню всех динамических таблиц
     */
    public String rootPath() {
        return pathSettings.getString("root") + version();
    }

    public String version() {
        return pathSettings.getString("version");
    }
}
