package ru.yandex.direct.mysql.ytsync.task.instances;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.binlogbroker.replicatetoyt.SchemaManager;
import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.AGGR_STATUSES_BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_INTERNAL;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGES;
import static ru.yandex.direct.dbschema.ppc.Tables.IMAGES;

@Lazy
@Component
@ParametersAreNonnullByDefault
public class BannersTask extends TaskProvider {
    private static final int PARTITIONS = 64;
    private static final PivotKeys PIVOT_KEYS = PivotKeys.hashModPartitions(PARTITIONS);

    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(BANNERS.getName(), BANNERS.BID.getName())
                    .leftJoin(IMAGES.getName(), IMAGES.BID.getName())
                    .leftJoin(BANNER_IMAGES.getName(), BANNER_IMAGES.BID.getName())
                    .leftJoin(BANNERS_PERFORMANCE.getName(), BANNERS_PERFORMANCE.BID.getName())
                    .leftJoin(BANNERS_INTERNAL.getName(), BANNERS_INTERNAL.BID.getName())
                    .leftJoin(AGGR_STATUSES_BANNERS.getName(), AGGR_STATUSES_BANNERS.BID.getName());
    private static final SyncTask BANNERS_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::bannersPath, PIVOT_KEYS)
                    .expressionKey("cid_hash",
                            SchemaManager.getHashColumnExpression(List.of(BANNERS.CID.getName()), PARTITIONS)
                    )
                    .longKey(BANNERS.CID)
                    .longKey(BANNERS.PID)
                    .longKey(BANNERS.BID, 2)
                    .shardKey("__shard__", 1)
                    .enumField(BANNERS.TYPE)
                    .field(BANNERS.TITLE)
                    .field(BANNERS.TITLE_EXTENSION)
                    .field(BANNERS.BODY)
                    .field(BANNERS.HREF)
                    .field(BANNERS.DOMAIN_ID)
                    .field(BANNERS.BANNER_ID)
                    .enumField(BANNERS.STATUS_SHOW)
                    .enumField(BANNERS.STATUS_ACTIVE)
                    .enumField(BANNERS.STATUS_MODERATE)
                    .enumField(BANNERS.STATUS_ARCH)
                    .dateTimeField(BANNERS.LAST_CHANGE)
                    .enumField(BANNERS.STATUS_BS_SYNCED)
                    .field(BANNERS.DOMAIN)
                    .enumField(BANNERS.PHONEFLAG)
                    .field(BANNERS.REVERSE_DOMAIN)
                    .enumField(BANNERS.STATUS_POST_MODERATE)
                    .field(BANNERS.VCARD_ID)
                    .field(BANNERS.FLAGS)
                    .field(BANNERS.SITELINKS_SET_ID)
                    .enumField(BANNERS.STATUS_SITELINKS_MODERATE)
                    .flagSetField(BANNERS.OPTS, "geoflag")
                    .flagSetField(BANNERS.OPTS, "no_display_href")
                    .enumField(BANNERS.BANNER_TYPE)
                    .field(IMAGES.IMAGE_HASH, "images_image_hash")
                    .enumField(IMAGES.STATUS_MODERATE, "imagesStatusModerate")
                    .field(BANNER_IMAGES.IMAGE_HASH, "banner_images_image_hash")
                    .enumField(BANNER_IMAGES.STATUS_MODERATE, "bannerImagesStatusModerate")
                    .field(BANNERS_PERFORMANCE.CREATIVE_ID)
                    .enumField(BANNERS_PERFORMANCE.STATUS_MODERATE, "bannersPerformanceStatusModerate")
                    .field(BANNERS_INTERNAL.DESCRIPTION, "bannersInternalDescription")
                    .field(BANNERS_INTERNAL.TEMPLATE_ID, "bannersInternalTemplateId")
                    .field(AGGR_STATUSES_BANNERS.AGGR_DATA)
                    .field(AGGR_STATUSES_BANNERS.IS_OBSOLETE, "aggr_is_obsolete")
                    .build();

    public BannersTask() {
        super(BANNERS_TASK, 70L);
    }
}
