package ru.yandex.direct.mysql.ytsync.task.instances;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.binlogbroker.replicatetoyt.SchemaManager;
import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;
import ru.yandex.direct.mysql.ytsync.util.KeywordsParser;

import static ru.yandex.direct.dbschema.ppc.Tables.BIDS;
import static ru.yandex.direct.dbschema.ppc.Tables.BIDS_ARC;
import static ru.yandex.direct.dbschema.ppc.Tables.BIDS_BASE;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.IS_ARCHIEVED;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.IS_DELETED_FIELD;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.KEYWORD_TYPE;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.MINUS_KEYWORDS_FIELD;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.NET_STOP_FIELD;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.PLAIN_KEYWORD_FIELD;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.SEARCH_STOP_FIELD;

@Lazy
@Component
@ParametersAreNonnullByDefault
public class BidsArcTask extends TaskProvider {
    private static final int PARTITIONS = 128;
    private static final PivotKeys PIVOT_KEYS = PivotKeys.hashModPartitions(PARTITIONS);

    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(BIDS_ARC.getName(), BIDS_ARC.CID.getName());
    private static final SyncTask BIDS_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::bidsPath, PIVOT_KEYS)
                    .expressionKey("__hash__",
                            SchemaManager.getHashColumnExpression(List.of(BIDS.CID.getName()), PARTITIONS)
                    )
                    .longKey(BIDS_ARC.CID)
                    .longKey(BIDS_ARC.PID)
                    .longKey(BIDS_ARC.ID, 2)
                    .shardKey("__shard__", 1)
                    .field(BIDS_ARC.PHRASE_ID)
                    .field(BIDS_ARC.PHRASE)
                    .stringField(BIDS_ARC.PHRASE, PLAIN_KEYWORD_FIELD, KeywordsParser::getPlainKeyword)
                    .stringField(BIDS_ARC.PHRASE, MINUS_KEYWORDS_FIELD, KeywordsParser::getMinusKeywords)
                    .moneyField(BIDS_ARC.PRICE)
                    .moneyField(BIDS_ARC.PRICE_CONTEXT)
                    .field(BIDS_ARC.SHOWS_FORECAST)
                    .enumField(BIDS_ARC.STATUS_MODERATE)
                    .field(BIDS_ARC.AUTOBUDGET_PRIORITY)
                    .field(BIDS_ARC.IS_SUSPENDED)
                    .constField(IS_DELETED_FIELD, (Long) null)
                    .constField(NET_STOP_FIELD, (Long) null)
                    .constField(SEARCH_STOP_FIELD, (Long) null)
                    .constField(BIDS_BASE.BID_TYPE.getName(), KEYWORD_TYPE)
                    .constField(IS_ARCHIEVED, true)
                    .build();

    public BidsArcTask() {
        super(BIDS_TASK, 95L);
    }
}
