package ru.yandex.direct.mysql.ytsync.task.instances;

import java.util.List;
import java.util.function.Predicate;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.binlogbroker.replicatetoyt.SchemaManager;
import ru.yandex.direct.dbschema.ppc.enums.BidsBaseBidType;
import ru.yandex.direct.mysql.MySQLSimpleRow;
import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.synchronizator.util.YtSyncUtil;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;
import ru.yandex.misc.lang.number.UnsignedLong;

import static java.util.Arrays.asList;
import static ru.yandex.direct.dbschema.ppc.Tables.BIDS;
import static ru.yandex.direct.dbschema.ppc.Tables.BIDS_BASE;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.IS_ARCHIEVED;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.IS_DELETED_FIELD;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.MINUS_KEYWORDS_FIELD;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.NET_STOP_FIELD;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.PLAIN_KEYWORD_FIELD;
import static ru.yandex.direct.mysql.ytsync.task.instances.BidsTask.SEARCH_STOP_FIELD;

@Lazy
@Component
@ParametersAreNonnullByDefault
public class BidsBaseTask extends TaskProvider {
    private static final int PARTITIONS = 128;
    private static final PivotKeys PIVOT_KEYS = PivotKeys.hashModPartitions(PARTITIONS);

    private static final Predicate<MySQLSimpleRow> SKIP_PREDICATE = YtSyncUtil::isKeywordOfBidsBase;
    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(BIDS_BASE.getName(), BIDS_BASE.CID.getName())
                    .whereIn(BIDS_BASE.BID_TYPE.getName(),
                            asList(
                                    BidsBaseBidType.relevance_match.getLiteral(),
                                    BidsBaseBidType.relevance_match_search.getLiteral())
                    );
    private static final SyncTask BIDS_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::bidsPath, PIVOT_KEYS)
                    .expressionKey("__hash__",
                            SchemaManager.getHashColumnExpression(List.of(BIDS.CID.getName()), PARTITIONS)
                    )
                    .longKey(BIDS_BASE.CID)
                    .longKey(BIDS_BASE.PID)
                    .longKey(BIDS_BASE.BID_ID, BIDS.ID.getName(), 2)
                    .shardKey("__shard__", 1)
                    .constField(BIDS.PHRASE_ID.getName(), UnsignedLong.valueOf(11))
                    .constField(BIDS.PHRASE.getName(), (String) null)
                    .constField(PLAIN_KEYWORD_FIELD, (String) null)
                    .constField(MINUS_KEYWORDS_FIELD, (String) null)
                    .moneyField(BIDS_BASE.PRICE)
                    .moneyField(BIDS_BASE.PRICE_CONTEXT)
                    .constField(BIDS.SHOWS_FORECAST.getName(), (Long) null)
                    .constField(BIDS.STATUS_MODERATE.getName(), (String) null)
                    .field(BIDS_BASE.AUTOBUDGET_PRIORITY)
                    .numFlagSetField(BIDS_BASE.OPTS, "suspended", BIDS.IS_SUSPENDED.getName())
                    .numFlagSetField(BIDS_BASE.OPTS, "deleted", IS_DELETED_FIELD)
                    .numFlagSetField(BIDS_BASE.OPTS, "net_stop", NET_STOP_FIELD)
                    .numFlagSetField(BIDS_BASE.OPTS, "search_stop", SEARCH_STOP_FIELD)
                    .enumField(BIDS_BASE.BID_TYPE)
                    .constField(IS_ARCHIEVED, false)
                    .build(SKIP_PREDICATE);

    public BidsBaseTask() {
        super(BIDS_TASK, 100L);
    }
}
