package ru.yandex.direct.mysql.ytsync.task.instances;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.binlogbroker.replicatetoyt.SchemaManager;
import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.AGGR_STATUSES_RETARGETINGS;
import static ru.yandex.direct.dbschema.ppc.Tables.BIDS_RETARGETING;

@Lazy
@Component
@ParametersAreNonnullByDefault
public class BidsRetargetingTask extends TaskProvider {
    private static final int PARTITIONS = 128;
    private static final PivotKeys PIVOT_KEYS = PivotKeys.hashModPartitions(PARTITIONS);

    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(BIDS_RETARGETING.getName(), BIDS_RETARGETING.RET_ID.getName())
                    .leftJoin(AGGR_STATUSES_RETARGETINGS.getName(), AGGR_STATUSES_RETARGETINGS.RET_ID.getName());
    private static final SyncTask BIDS_RETARGETING_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::bidsRetargetingPath, PIVOT_KEYS)
                    .expressionKey("__hash__",
                            SchemaManager.getHashColumnExpression(List.of(BIDS_RETARGETING.CID.getName()), PARTITIONS)
                    )
                    .longKey(BIDS_RETARGETING.RET_ID, 2)
                    .longKey(BIDS_RETARGETING.RET_COND_ID)
                    .longKey(BIDS_RETARGETING.CID)
                    .longKey(BIDS_RETARGETING.PID)
                    .longKey(BIDS_RETARGETING.BID)
                    .shardKey("__shard__", 1)
                    .dateTimeField(BIDS_RETARGETING.MODTIME)
                    .moneyField(BIDS_RETARGETING.PRICE_CONTEXT)
                    .enumField(BIDS_RETARGETING.STATUS_BS_SYNCED)
                    .field(BIDS_RETARGETING.IS_SUSPENDED)
                    .field(BIDS_RETARGETING.REACH)
                    .field(BIDS_RETARGETING.AUTOBUDGET_PRIORITY)
                    .field(AGGR_STATUSES_RETARGETINGS.AGGR_DATA)
                    .field(AGGR_STATUSES_RETARGETINGS.IS_OBSOLETE, "aggr_is_obsolete")
                    .build();

    public BidsRetargetingTask() {
        super(BIDS_RETARGETING_TASK, 55L);
    }
}
