package ru.yandex.direct.mysql.ytsync.task.instances;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.binlogbroker.replicatetoyt.SchemaManager;
import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;
import ru.yandex.direct.mysql.ytsync.util.KeywordsParser;

import static ru.yandex.direct.dbschema.ppc.Tables.BIDS;
import static ru.yandex.direct.dbschema.ppc.Tables.BIDS_BASE;

@Lazy
@Component
@ParametersAreNonnullByDefault
public class BidsTask extends TaskProvider {
    static final String IS_DELETED_FIELD = "is_deleted";
    static final String SEARCH_STOP_FIELD = "search_stop";
    static final String NET_STOP_FIELD = "net_stop";
    static final String KEYWORD_TYPE = "keyword";
    static final String PLAIN_KEYWORD_FIELD = "keyword";
    static final String MINUS_KEYWORDS_FIELD = "minus_words";
    static final String IS_ARCHIEVED = "is_archived";

    private static final int PARTITIONS = 128;
    private static final PivotKeys PIVOT_KEYS = PivotKeys.hashModPartitions(PARTITIONS);

    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(BIDS.getName(), BIDS.ID.getName());
    private static final SyncTask BIDS_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::bidsPath, PIVOT_KEYS)
                    .expressionKey("__hash__",
                            SchemaManager.getHashColumnExpression(List.of(BIDS.CID.getName()), PARTITIONS)
                    )
                    .longKey(BIDS.CID)
                    .longKey(BIDS.PID)
                    .longKey(BIDS.ID, 2)
                    .shardKey("__shard__", 1)
                    .field(BIDS.PHRASE_ID)
                    .field(BIDS.PHRASE)
                    .stringField(BIDS.PHRASE, PLAIN_KEYWORD_FIELD, KeywordsParser::getPlainKeyword)
                    .stringField(BIDS.PHRASE, MINUS_KEYWORDS_FIELD, KeywordsParser::getMinusKeywords)
                    .moneyField(BIDS.PRICE)
                    .moneyField(BIDS.PRICE_CONTEXT)
                    .field(BIDS.SHOWS_FORECAST)
                    .enumField(BIDS.STATUS_MODERATE)
                    .field(BIDS.AUTOBUDGET_PRIORITY)
                    .field(BIDS.IS_SUSPENDED)
                    .constField(IS_DELETED_FIELD, (Long) null)
                    .constField(NET_STOP_FIELD, (Long) null)
                    .constField(SEARCH_STOP_FIELD, (Long) null)
                    .constField(BIDS_BASE.BID_TYPE.getName(), KEYWORD_TYPE)
                    .constField(IS_ARCHIEVED, false)
                    .build();

    public BidsTask() {
        super(BIDS_TASK, 90L);
    }
}
