package ru.yandex.direct.mysql.ytsync.task.instances;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.binlogbroker.replicatetoyt.SchemaManager;
import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;
import ru.yandex.direct.mysql.ytsync.util.CampaignsParser;
import ru.yandex.direct.mysql.ytsync.util.FieldValuesParser;

import static ru.yandex.direct.dbschema.ppc.Tables.AGGR_STATUSES_CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_INTERNAL;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_METRIKA_COUNTERS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;

@Lazy
@Component
@ParametersAreNonnullByDefault
public class CampaignsTask extends TaskProvider {
    private static final int PARTITIONS = 64;
    private static final PivotKeys PIVOT_KEYS = PivotKeys.hashModPartitions(PARTITIONS);

    private static final String ALIAS_OF_CAMPAIGNS = "campaigns";
    private static final String ALIAS_OF_CAMP_OPTIONS = "camp_options";
    private static final String ALIAS_OF_CAMP_METRIKA_COUNTERS = "camp_metrika_counters";
    private static final String ALIAS_OF_CAMPAIGNS_INTERNAL = "campaigns_internal";
    private static final String ALIAS_OF_AGGR_STATUSES_CAMPAIGNS = "aggr_statuses_campaigns";
    private static final String ALIAS_OF_WALLETS = "wallets";
    private static final String ALIAS_OF_WALLET_OPTIONS = "wallet_options";
    private static final String ALIAS_OF_AGGR_STATUSES_WALLETS = "aggr_statuses_wallets";

    private static final String FIELD_STRATEGY_DATA_NAME = "strategy_data";
    private static final String FIELD_START_TIME_DATE_NAME = "start_time_date";
    private static final String FIELD_FINISH_TIME_DATE_NAME = "finish_time_date";
    private static final String FIELD_DAY_BUDGET_STOP_TIME_NAME = "day_budget_stop_time";
    private static final String FIELD_AGGR_DATA_NAME = "aggr_data";
    private static final String FIELD_WALLET_DAY_BUDGET_NAME = "wallet_day_budget";
    private static final String FIELD_WALLET_DAY_BUDGET_STOP_TIME_NAME = "wallet_day_budget_stop_time";
    private static final String FIELD_WALLET_AGGR_DATA_NAME = "wallet_aggr_data";

    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(CAMPAIGNS.getName(), ALIAS_OF_CAMPAIGNS, CAMPAIGNS.CID.getName())
                    .leftJoin(CAMP_OPTIONS.getName(), ALIAS_OF_CAMP_OPTIONS, CAMPAIGNS.CID.getName())
                    .leftJoin(CAMP_METRIKA_COUNTERS.getName(), ALIAS_OF_CAMP_METRIKA_COUNTERS, CAMPAIGNS.CID.getName())
                    .leftJoin(CAMPAIGNS_INTERNAL.getName(), ALIAS_OF_CAMPAIGNS_INTERNAL, CAMPAIGNS.CID.getName())
                    .leftJoin(AGGR_STATUSES_CAMPAIGNS.getName(), ALIAS_OF_AGGR_STATUSES_CAMPAIGNS,
                            CAMPAIGNS.CID.getName())
                    // для получения данных о кошельке
                    .leftJoin(CAMPAIGNS.getName(), ALIAS_OF_WALLETS,
                            CAMPAIGNS.CID.getName(), CAMPAIGNS.WALLET_CID.getName())
                    .leftJoin(CAMP_OPTIONS.getName(), ALIAS_OF_WALLET_OPTIONS,
                            CAMP_OPTIONS.CID.getName(), CAMPAIGNS.WALLET_CID.getName())
                    .leftJoin(AGGR_STATUSES_CAMPAIGNS.getName(), ALIAS_OF_AGGR_STATUSES_WALLETS,
                            AGGR_STATUSES_CAMPAIGNS.CID.getName(), CAMPAIGNS.WALLET_CID.getName());
    private static final SyncTask CAMPAIGNS_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::campaignsPath, PIVOT_KEYS)
                    .expressionKey("__hash__",
                            SchemaManager.getHashColumnExpression(List.of(CAMPAIGNS.CID.getName()), PARTITIONS)
                    )
                    .longKey(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.CID)
                    .shardKey("__shard__")
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.TYPE)
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.NAME)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.CURRENCY)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.STATUS_MODERATE)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.STATUS_SHOW)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.STATUS_ACTIVE)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.STATUS_EMPTY)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.STATUS_BS_SYNCED)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.STATUS_NO_PAY)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.STATUS_AUTOBUDGET_FORECAST)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.STATUS_BS_ARCHIVED)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.STATUS_OPEN_STAT)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.STATUS_BEHAVIOR)
                    .enumField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.ARCHIVED)
                    .dateField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.START_TIME)
                    .dateField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.FINISH_TIME)
                    // from table campaigns
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.ORDER_ID)
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.GEO)
                    .flagSetField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.OPTS, "no_extended_geotargeting")
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.TIME_TARGET)
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.CONTEXT_LIMIT)
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.DONT_SHOW)
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.DISABLED_SSP)
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.DISABLED_IPS)
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.SHOWS)
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.CLICKS)
                    .moneyField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.SUM, CAMPAIGNS.SUM.getName())
                    .moneyField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.SUM_SPENT, CAMPAIGNS.SUM_SPENT.getName())
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.SUM_UNITS)
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.SUM_SPENT_UNITS)
                    .field(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.WALLET_CID)
                    .ysonField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.STRATEGY_DATA, FIELD_STRATEGY_DATA_NAME,
                            CampaignsParser::convertStrategyDataToJsonString)
                    .moneyField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.DAY_BUDGET, CAMPAIGNS.DAY_BUDGET.getName())
                    .moneyField(ALIAS_OF_WALLETS, CAMPAIGNS.DAY_BUDGET, FIELD_WALLET_DAY_BUDGET_NAME)
                    .dateField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.START_TIME, FIELD_START_TIME_DATE_NAME,
                            FieldValuesParser::toLongFromLocalDate)
                    .dateField(ALIAS_OF_CAMPAIGNS, CAMPAIGNS.FINISH_TIME, FIELD_FINISH_TIME_DATE_NAME,
                            FieldValuesParser::toLongFromLocalDate)
                    // from table camp_options
                    .field(ALIAS_OF_CAMP_OPTIONS, CAMP_OPTIONS.MINUS_WORDS)
                    .enumField(ALIAS_OF_CAMP_OPTIONS, CAMP_OPTIONS.BROAD_MATCH_FLAG)
                    .dateTimeField(ALIAS_OF_CAMP_OPTIONS, CAMP_OPTIONS.DAY_BUDGET_STOP_TIME,
                            FIELD_DAY_BUDGET_STOP_TIME_NAME, FieldValuesParser::toLongFromLocalDateTime)
                    .dateTimeField(ALIAS_OF_WALLET_OPTIONS, CAMP_OPTIONS.DAY_BUDGET_STOP_TIME,
                            FIELD_WALLET_DAY_BUDGET_STOP_TIME_NAME, FieldValuesParser::toLongFromLocalDateTime)
                    // from table camp_metrika_counters
                    .field(ALIAS_OF_CAMP_METRIKA_COUNTERS, CAMP_METRIKA_COUNTERS.METRIKA_COUNTERS)
                    // from table campaigns_internal
                    .field(ALIAS_OF_CAMPAIGNS_INTERNAL, CAMPAIGNS_INTERNAL.RESTRICTION_VALUE)
                    .enumField(ALIAS_OF_CAMPAIGNS_INTERNAL, CAMPAIGNS_INTERNAL.RESTRICTION_TYPE)
                    // from table aggr_statuses_campaigns
                    .ysonField(ALIAS_OF_AGGR_STATUSES_CAMPAIGNS, AGGR_STATUSES_CAMPAIGNS.AGGR_DATA,
                            FIELD_AGGR_DATA_NAME, FieldValuesParser::toJsonString)
                    .ysonField(ALIAS_OF_AGGR_STATUSES_WALLETS, AGGR_STATUSES_CAMPAIGNS.AGGR_DATA,
                            FIELD_WALLET_AGGR_DATA_NAME, FieldValuesParser::toJsonString)
                    .build();

    public CampaignsTask() {
        super(CAMPAIGNS_TASK, 10L);
    }
}
