package ru.yandex.direct.mysql.ytsync.task.instances;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.binlogbroker.replicatetoyt.SchemaManager;
import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.PERF_CREATIVES;


@Lazy
@Component
@ParametersAreNonnullByDefault
public class PerfCreativesTask extends TaskProvider {
    private static final int PARTITIONS = 64;
    private static final PivotKeys PIVOT_KEYS = PivotKeys.hashModPartitions(PARTITIONS);

    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(PERF_CREATIVES.getName(), PERF_CREATIVES.CREATIVE_ID.getName());
    private static final SyncTask PERF_CREATIVES_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::perfCreativesPath, PIVOT_KEYS)
                    .expressionKey("__hash__",
                            SchemaManager.getHashColumnExpression(List.of(PERF_CREATIVES.CREATIVE_ID.getName()), PARTITIONS)
                    )
                    .longKey(PERF_CREATIVES.CREATIVE_ID)
                    .longKey(PERF_CREATIVES.CLIENT_ID)
                    .shardKey("__shard__", 1)
                    .enumField(PERF_CREATIVES.STATUS_MODERATE)
                    .field(PERF_CREATIVES.IS_GENERATED)
                    .build();

    public PerfCreativesTask() {
        super(PERF_CREATIVES_TASK, 50L);
    }
}
